/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;

public class CloverCleanMojo
extends AbstractCloverMojo {
    protected boolean skip;
    protected boolean keepDb;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        Project project = new Project();
        project.setBasedir(this.getProject().getBasedir().getPath());
        project.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        project.init();
        File snapshotFile = new ConfigUtil(this).resolveSnapshotFile(this.snapshot);
        this.removeFile(snapshotFile, project);
        this.removeDir(new File(this.cloverOutputDirectory), project);
    }

    private void removeDir(File dir, Project project) throws MojoExecutionException {
        if (!dir.exists() || dir.isFile()) {
            return;
        }
        this.getLog().debug((CharSequence)("Deleting directory: " + dir.getAbsolutePath()));
        Delete delete = this.createDeleteTaskFor(project);
        delete.setDir(dir);
        if (this.keepDb) {
            delete.setExcludes("**/*.db");
        }
        delete.execute();
        if (dir.exists()) {
            this.getLog().warn((CharSequence)("clover2:clean could not delete directory: " + dir));
        }
    }

    private Delete createDeleteTaskFor(Project project) {
        Delete delete = new Delete();
        delete.setProject(project);
        delete.setIncludeEmptyDirs(true);
        delete.init();
        return delete;
    }

    private void removeFile(File file, Project project) throws MojoExecutionException {
        if (!file.exists() || file.isDirectory()) {
            return;
        }
        this.getLog().debug((CharSequence)("Deleting file: " + file.getAbsolutePath()));
        Delete delete = this.createDeleteTaskFor(project);
        delete.setFile(file);
        delete.execute();
        if (file.exists()) {
            this.getLog().warn((CharSequence)("clover2:clean could not delete file: " + file));
        }
    }
}

