/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.scanner;

import com.atlassian.clover.spi.lang.Language;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.AbstractSourceScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainSourceScanner
extends AbstractSourceScanner {
    @NotNull
    public static final String SRC_MAIN_JAVA = "src" + File.separator + "main" + File.separator + "java";
    @NotNull
    public static final String SRC_MAIN_GROOVY = "src" + File.separator + "main" + File.separator + "groovy";

    public MainSourceScanner(CompilerConfiguration configuration, String outputSourceDirectory) {
        super(configuration, outputSourceDirectory);
    }

    @Override
    public void removeGroovySourceRoot(@NotNull Set<String> sourceRoots) {
        this.removeSourceRoot(sourceRoots, SRC_MAIN_GROOVY);
    }

    @Override
    public boolean isSourceRootForLanguage(String sourceRoot, Language language) {
        return language.getName().equals(Language.Builtin.JAVA.getName()) && sourceRoot.endsWith(SRC_MAIN_JAVA) || language.getName().equals(Language.Builtin.GROOVY.getName()) && sourceRoot.endsWith(SRC_MAIN_GROOVY);
    }

    @Override
    protected List<String> getCompileSourceRoots() {
        ArrayList<String> roots = new ArrayList<String>(this.getConfiguration().getProject().getCompileSourceRoots());
        roots.add(SRC_MAIN_GROOVY);
        return roots;
    }

    @Override
    protected String getSourceDirectory() {
        return this.getConfiguration().getProject().getBuild().getSourceDirectory();
    }
}

