/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.bridge;

import com.atlassian.oauth.ServiceProvider;
import com.google.common.base.Preconditions;
import java.net.URI;
import net.oauth.OAuthServiceProvider;

public final class ServiceProviders {
    private ServiceProviders() {
    }

    public static OAuthServiceProvider asOAuthServiceProvider(ServiceProvider serviceProvider) {
        Preconditions.checkNotNull((Object)serviceProvider, (Object)"serviceProvider");
        return new OAuthServiceProvider(serviceProvider.getRequestTokenUri().normalize().toString(), serviceProvider.getAuthorizeUri().normalize().toString(), serviceProvider.getAccessTokenUri().normalize().toString());
    }

    public static ServiceProvider fromOAuthServiceProvider(OAuthServiceProvider serviceProvider) {
        Preconditions.checkNotNull((Object)serviceProvider, (Object)"serviceProvider");
        return new ServiceProvider(URI.create(serviceProvider.requestTokenURL), URI.create(serviceProvider.userAuthorizationURL), URI.create(serviceProvider.accessTokenURL));
    }
}

