/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.config;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;
import org.ofbiz.core.entity.GenericDAO;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityConfException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelperFactory;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilValidate;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityConfigUtil {
    public static final String ENTITY_ENGINE_XML_FILENAME = "entityengine.xml";
    protected String txFactoryClass;
    protected String txFactoryUserTxJndiName;
    protected String txFactoryUserTxJndiServerName;
    protected String txFactoryTxMgrJndiName;
    protected String txFactoryTxMgrJndiServerName;
    protected Map<String, ResourceLoaderInfo> resourceLoaderInfos = CopyOnWriteMap.newHashMap();
    protected Map<String, DelegatorInfo> delegatorInfos = CopyOnWriteMap.newHashMap();
    protected Map<String, EntityModelReaderInfo> entityModelReaderInfos = CopyOnWriteMap.newHashMap();
    protected Map<String, EntityGroupReaderInfo> entityGroupReaderInfos = CopyOnWriteMap.newHashMap();
    protected Map<String, EntityEcaReaderInfo> entityEcaReaderInfos = CopyOnWriteMap.newHashMap();
    protected Map<String, FieldTypeInfo> fieldTypeInfos = CopyOnWriteMap.newHashMap();
    protected Map<String, DatasourceInfo> datasourceInfos = CopyOnWriteMap.newHashMap();
    private static volatile EntityConfigUtil singletonInstance;

    public static EntityConfigUtil getInstance() {
        EntityConfigUtil existing = singletonInstance;
        return existing != null ? existing : EntityConfigUtil.getInstanceUnderLock();
    }

    private static synchronized EntityConfigUtil getInstanceUnderLock() {
        EntityConfigUtil created;
        EntityConfigUtil existing = singletonInstance;
        if (existing != null) {
            return existing;
        }
        singletonInstance = created = new EntityConfigUtil();
        return created;
    }

    protected Element getXmlRootElement() throws GenericEntityConfException {
        try {
            return ResourceLoader.getXmlRootElement((String)ENTITY_ENGINE_XML_FILENAME);
        }
        catch (GenericConfigException e) {
            throw new GenericEntityConfException("Could not get entity engine XML root element", e);
        }
    }

    protected Document getXmlDocument() throws GenericEntityConfException {
        try {
            return ResourceLoader.getXmlDocument((String)ENTITY_ENGINE_XML_FILENAME);
        }
        catch (GenericConfigException e) {
            throw new GenericEntityConfException("Could not get entity engine XML document", e);
        }
    }

    public EntityConfigUtil() {
        try {
            this.initialize(this.getXmlRootElement());
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Error loading entity config XML file entityengine.xml");
        }
    }

    public EntityConfigUtil(String filename) {
        try {
            this.initialize(ResourceLoader.getXmlRootElement((String)filename));
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Error loading entity config XML file entityengine.xml");
        }
    }

    public synchronized void reinitialize() throws GenericEntityException {
        try {
            ResourceLoader.invalidateDocument((String)ENTITY_ENGINE_XML_FILENAME);
            this.initialize(this.getXmlRootElement());
        }
        catch (Exception e) {
            throw new GenericEntityException("Error reloading entity config XML file entityengine.xml", e);
        }
    }

    public synchronized void removeDatasource(String helperName) {
        GenericHelperFactory.removeHelper(helperName);
        GenericDAO.removeGenericDAO(helperName);
        TransactionFactory.getTransactionFactory().removeDatasource(helperName);
        this.datasourceInfos.remove(helperName);
    }

    public synchronized void addDatasourceInfo(DatasourceInfo datasourceInfo) {
        this.datasourceInfos.put(datasourceInfo.getName(), datasourceInfo);
    }

    public synchronized void removeDelegator(String delegatorName) {
        this.delegatorInfos.remove(delegatorName);
        GenericDelegator.removeGenericDelegator(delegatorName);
    }

    public synchronized void addDelegatorInfo(DelegatorInfo delegatorInfo) {
        this.delegatorInfos.put(delegatorInfo.name, delegatorInfo);
    }

    public void initialize(Element rootElement) throws GenericEntityException {
        Element transactionFactoryElement = UtilXml.firstChildElement((Element)rootElement, (String)"transaction-factory");
        if (transactionFactoryElement == null) {
            throw new GenericEntityConfException("ERROR: no transaction-factory definition was found in entityengine.xml");
        }
        this.txFactoryClass = transactionFactoryElement.getAttribute("class");
        Element userTxJndiElement = UtilXml.firstChildElement((Element)transactionFactoryElement, (String)"user-transaction-jndi");
        if (userTxJndiElement != null) {
            this.txFactoryUserTxJndiName = userTxJndiElement.getAttribute("jndi-name");
            this.txFactoryUserTxJndiServerName = userTxJndiElement.getAttribute("jndi-server-name");
        } else {
            this.txFactoryUserTxJndiName = null;
            this.txFactoryUserTxJndiServerName = null;
        }
        Element txMgrJndiElement = UtilXml.firstChildElement((Element)transactionFactoryElement, (String)"transaction-manager-jndi");
        if (txMgrJndiElement != null) {
            this.txFactoryTxMgrJndiName = txMgrJndiElement.getAttribute("jndi-name");
            this.txFactoryTxMgrJndiServerName = txMgrJndiElement.getAttribute("jndi-server-name");
        } else {
            this.txFactoryTxMgrJndiName = null;
            this.txFactoryTxMgrJndiServerName = null;
        }
        List childElements = null;
        Iterator elementIter = null;
        childElements = UtilXml.childElementList((Element)rootElement, (String)"resource-loader");
        for (Element curElement : childElements) {
            ResourceLoaderInfo resourceLoaderInfo = new ResourceLoaderInfo(curElement);
            this.resourceLoaderInfos.put(resourceLoaderInfo.name, resourceLoaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"delegator");
        for (Element curElement : childElements) {
            DelegatorInfo delegatorInfo = new DelegatorInfo(curElement);
            this.delegatorInfos.put(delegatorInfo.name, delegatorInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"entity-model-reader");
        for (Element curElement : childElements) {
            EntityModelReaderInfo entityModelReaderInfo = new EntityModelReaderInfo(curElement);
            this.entityModelReaderInfos.put(entityModelReaderInfo.name, entityModelReaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"entity-group-reader");
        for (Element curElement : childElements) {
            EntityGroupReaderInfo entityGroupReaderInfo = new EntityGroupReaderInfo(curElement);
            this.entityGroupReaderInfos.put(entityGroupReaderInfo.name, entityGroupReaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"entity-eca-reader");
        for (Element curElement : childElements) {
            EntityEcaReaderInfo entityEcaReaderInfo = new EntityEcaReaderInfo(curElement);
            this.entityEcaReaderInfos.put(entityEcaReaderInfo.name, entityEcaReaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"field-type");
        for (Element curElement : childElements) {
            FieldTypeInfo fieldTypeInfo = new FieldTypeInfo(curElement);
            this.fieldTypeInfos.put(fieldTypeInfo.name, fieldTypeInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"datasource");
        if (childElements != null) {
            for (Element curElement : childElements) {
                DatasourceInfo datasourceInfo = new DatasourceInfo(curElement);
                this.datasourceInfos.put(datasourceInfo.getName(), datasourceInfo);
            }
        }
    }

    public String getTxFactoryClass() {
        return this.txFactoryClass;
    }

    public String getTxFactoryUserTxJndiName() {
        return this.txFactoryUserTxJndiName;
    }

    public String getTxFactoryUserTxJndiServerName() {
        return this.txFactoryUserTxJndiServerName;
    }

    public String getTxFactoryTxMgrJndiName() {
        return this.txFactoryTxMgrJndiName;
    }

    public String getTxFactoryTxMgrJndiServerName() {
        return this.txFactoryTxMgrJndiServerName;
    }

    public ResourceLoaderInfo getResourceLoaderInfo(String name) {
        return this.resourceLoaderInfos.get(name);
    }

    public DelegatorInfo getDelegatorInfo(String name) {
        return this.delegatorInfos.get(name);
    }

    public EntityModelReaderInfo getEntityModelReaderInfo(String name) {
        return this.entityModelReaderInfos.get(name);
    }

    public EntityGroupReaderInfo getEntityGroupReaderInfo(String name) {
        return this.entityGroupReaderInfos.get(name);
    }

    public EntityEcaReaderInfo getEntityEcaReaderInfo(String name) {
        return this.entityEcaReaderInfos.get(name);
    }

    public FieldTypeInfo getFieldTypeInfo(String name) {
        return this.fieldTypeInfos.get(name);
    }

    public DatasourceInfo getDatasourceInfo(String name) {
        return this.datasourceInfos.get(name);
    }

    public static class FieldTypeInfo {
        public String name;
        public Element resourceElement;

        public FieldTypeInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElement = element;
        }
    }

    public static class EntityEcaReaderInfo {
        public String name;
        public List<Element> resourceElements;

        public EntityEcaReaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElements = UtilXml.childElementList((Element)element, (String)"resource");
        }
    }

    public static class EntityGroupReaderInfo {
        public String name;
        public Element resourceElement;

        public EntityGroupReaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElement = element;
        }
    }

    public static class EntityModelReaderInfo {
        public String name;
        public List<Element> resourceElements;

        public EntityModelReaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElements = UtilXml.childElementList((Element)element, (String)"resource");
        }
    }

    public static class DelegatorInfo {
        public String name;
        public String entityModelReader;
        public String entityGroupReader;
        public String entityEcaReader;
        public boolean useDistributedCacheClear;
        public String distributedCacheClearClassName;
        public String distributedCacheClearUserLoginId;
        public Map<String, String> groupMap = new HashMap<String, String>();

        public DelegatorInfo(String name, String entityModelReader, String entityGroupReader, Map<String, String> groupMap) {
            this.name = name;
            this.entityModelReader = entityModelReader;
            this.entityGroupReader = entityGroupReader;
            this.groupMap = groupMap;
        }

        public DelegatorInfo(Element element) {
            this.name = element.getAttribute("name");
            this.entityModelReader = element.getAttribute("entity-model-reader");
            this.entityGroupReader = element.getAttribute("entity-group-reader");
            this.entityEcaReader = element.getAttribute("entity-eca-reader");
            this.useDistributedCacheClear = "true".equals(element.getAttribute("distributed-cache-clear-enabled"));
            this.distributedCacheClearClassName = element.getAttribute("distributed-cache-clear-class-name");
            if (UtilValidate.isEmpty((String)this.distributedCacheClearClassName)) {
                this.distributedCacheClearClassName = "org.ofbiz.core.extentity.EntityCacheServices";
            }
            this.distributedCacheClearUserLoginId = element.getAttribute("distributed-cache-clear-user-login-id");
            if (UtilValidate.isEmpty((String)this.distributedCacheClearUserLoginId)) {
                this.distributedCacheClearUserLoginId = "admin";
            }
            List groupMapList = UtilXml.childElementList((Element)element, (String)"group-map");
            for (Element groupMapElement : groupMapList) {
                this.groupMap.put(groupMapElement.getAttribute("group-name"), groupMapElement.getAttribute("datasource-name"));
            }
        }
    }

    public static class ResourceLoaderInfo {
        public String name;
        public String className;
        public String prependEnv;
        public String prefix;

        public ResourceLoaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.className = element.getAttribute("class");
            this.prependEnv = element.getAttribute("prepend-env");
            this.prefix = element.getAttribute("prefix");
        }
    }
}

