/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.log4j.Logger;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolInfoSynthesizer;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionTracker;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;

public class JNDIFactory
implements TransactionFactoryInterface {
    private static final Logger log = Logger.getLogger(JNDIFactory.class);
    public static final String module = JNDIFactory.class.getName();
    static TransactionManager transactionManager = null;
    static UserTransaction userTransaction = null;
    protected static Map<String, Object> dsCache = CopyOnWriteMap.newHashMap();
    protected static Map<String, ConnectionTracker> trackerCache = CopyOnWriteMap.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TransactionManager getTransactionManager() {
        if (transactionManager != null) return transactionManager;
        Class<JNDIFactory> clazz = JNDIFactory.class;
        synchronized (JNDIFactory.class) {
            if (transactionManager != null) return transactionManager;
            try {
                String jndiName = EntityConfigUtil.getInstance().getTxFactoryTxMgrJndiName();
                String jndiServerName = EntityConfigUtil.getInstance().getTxFactoryTxMgrJndiServerName();
                if (jndiName == null || jndiName.length() <= 0) return transactionManager;
                try {
                    InitialContext ic = JNDIContextFactory.getInitialContext((String)jndiServerName);
                    if (ic != null) {
                        transactionManager = (TransactionManager)ic.lookup(jndiName);
                    }
                }
                catch (NamingException ne) {
                    Debug.logWarning((Throwable)ne, (String)("NamingException while finding TransactionManager named " + jndiName + " in JNDI."), (String)module);
                    transactionManager = null;
                }
                if (transactionManager != null) return transactionManager;
                Debug.logWarning((String)("[JNDIFactory.getTransactionManager] Failed to find TransactionManager named " + jndiName + " in JNDI."), (String)module);
            }
            catch (GeneralException e) {
                Debug.logError((Throwable)e);
                transactionManager = null;
            }
            return transactionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UserTransaction getUserTransaction() {
        if (userTransaction != null) return userTransaction;
        Class<JNDIFactory> clazz = JNDIFactory.class;
        synchronized (JNDIFactory.class) {
            if (userTransaction != null) return userTransaction;
            try {
                String jndiName = EntityConfigUtil.getInstance().getTxFactoryUserTxJndiName();
                String jndiServerName = EntityConfigUtil.getInstance().getTxFactoryUserTxJndiServerName();
                if (jndiName == null || jndiName.length() <= 0) return userTransaction;
                try {
                    InitialContext ic = JNDIContextFactory.getInitialContext((String)jndiServerName);
                    if (ic != null) {
                        userTransaction = (UserTransaction)ic.lookup(jndiName);
                    }
                }
                catch (NamingException ne) {
                    Debug.logWarning((Throwable)ne, (String)("NamingException while finding UserTransaction named " + jndiName + " in JNDI."), (String)module);
                    userTransaction = null;
                }
                if (userTransaction != null) return userTransaction;
                Debug.logWarning((String)("[JNDIFactory.getUserTransaction] Failed to find UserTransaction named " + jndiName + " in JNDI."), (String)module);
            }
            catch (GeneralException e) {
                Debug.logError((Throwable)e);
                transactionManager = null;
            }
            return userTransaction;
        }
    }

    @Override
    public String getTxMgrName() {
        return "jndi";
    }

    @Override
    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        if (datasourceInfo.getJndiDatasource() != null) {
            JndiDatasourceInfo jndiDatasource = datasourceInfo.getJndiDatasource();
            Connection con = null;
            try {
                con = JNDIFactory.getJndiConnection(helperName, jndiDatasource.getJndiName(), jndiDatasource.getJndiServerName());
            }
            catch (AbstractMethodError err) {
                log.warn((Object)"*********************************************** IMPORTANT  ************************************************");
                log.warn((Object)"                                                                                                           ");
                log.warn((Object)"  We found that you may experience problems with database connectivity because your database driver        ");
                log.warn((Object)"  is not fully JDBC 4 compatible. As a workaround of this problem we suggest adding a validation query     ");
                log.warn((Object)"  to your database resource configuration in Tomcat's server.xml file:\n");
                log.warn((Object)"                           validationQuery=\"select 1;\"                                         \n");
                log.warn((Object)"  or to update your database driver to version which fully supports JDBC 4.                                  ");
                log.warn((Object)"  More information about this problem can be found here: https://jira.atlassian.com/browse/JRA-59768       ");
                log.warn((Object)"                                                                                                           ");
                log.warn((Object)"***********************************************************************************************************");
            }
            if (con != null) {
                return con;
            }
        }
        if (datasourceInfo.getJdbcDatasource() != null) {
            Connection otherCon = ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.getJdbcDatasource());
            return otherCon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getJndiConnection(String helperName, String jndiName, String jndiServerName) throws SQLException, GenericEntityException {
        Object ds = dsCache.get(jndiName);
        if (ds != null) {
            if (ds instanceof XADataSource) {
                XADataSource xads = (XADataSource)ds;
                return JNDIFactory.trackConnection(helperName, xads);
            }
            DataSource nds = (DataSource)ds;
            return JNDIFactory.trackConnection(helperName, nds);
        }
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            ds = dsCache.get(jndiName);
            if (ds != null) {
                if (ds instanceof XADataSource) {
                    XADataSource xads = (XADataSource)ds;
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return JNDIFactory.trackConnection(helperName, xads);
                }
                DataSource nds = (DataSource)ds;
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return JNDIFactory.trackConnection(helperName, nds);
            }
            try {
                InitialContext ic;
                if (Debug.infoOn()) {
                    Debug.logInfo((String)("Doing JNDI lookup for name " + jndiName), (String)module);
                }
                if ((ic = JNDIContextFactory.getInitialContext((String)jndiServerName)) != null) {
                    ds = ic.lookup(jndiName);
                } else {
                    Debug.logWarning((String)("Initial Context returned was NULL for server name " + jndiServerName), (String)module);
                }
                if (ds != null) {
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)"Got a Datasource object.", (String)module);
                    }
                    dsCache.put(jndiName, ds);
                    if (ds instanceof XADataSource) {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got XADataSource for name " + jndiName), (String)module);
                        }
                        XADataSource xads = (XADataSource)ds;
                        trackerCache.put(helperName, new ConnectionTracker());
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return JNDIFactory.trackConnection(helperName, xads);
                    }
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)("Got DataSource for name " + jndiName), (String)module);
                    }
                    DataSource nds = (DataSource)ds;
                    trackerCache.put(helperName, new ConnectionTracker(ConnectionPoolInfoSynthesizer.synthesizeConnectionPoolInfo(nds)));
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return JNDIFactory.trackConnection(helperName, nds);
                }
                Debug.logError((String)"Datasource returned was NULL.", (String)module);
            }
            catch (NamingException ne) {
                Debug.logWarning((Throwable)ne, (String)("[ConnectionFactory.getConnection] Failed to find DataSource named " + jndiName + " in JNDI server with name " + jndiServerName + ". Trying normal database."), (String)module);
            }
            catch (GenericConfigException gce) {
                throw new GenericEntityException("Problems with the JNDI configuration.", gce.getNested());
            }
            return null;
        }
    }

    private static Connection trackConnection(String helperName, final XADataSource xads) {
        ConnectionTracker connectionTracker = trackerCache.get(helperName);
        return connectionTracker.trackConnection(helperName, new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return TransactionUtil.enlistConnection(xads.getXAConnection());
            }
        });
    }

    private static Connection trackConnection(String helperName, final DataSource nds) {
        ConnectionTracker connectionTracker = trackerCache.get(helperName);
        return connectionTracker.trackConnection(helperName, new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return nds.getConnection();
            }
        });
    }

    @Override
    public void removeDatasource(String helperName) {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        if (datasourceInfo.getJndiDatasource() == null && datasourceInfo.getJdbcDatasource() != null) {
            ConnectionFactory.removeDatasource(helperName);
        }
        trackerCache.remove(helperName);
    }
}

