/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.onetime.service;

import com.atlassian.onetime.core.TOTP;
import com.atlassian.onetime.core.TOTPGenerator;
import com.atlassian.onetime.model.EmailAddress;
import com.atlassian.onetime.model.Issuer;
import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.onetime.service.TOTPConfiguration;
import com.atlassian.onetime.service.TOTPService;
import com.atlassian.onetime.service.TOTPServiceKt;
import com.atlassian.onetime.service.TOTPVerificationResult;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/onetime/service/DefaultTOTPService;", "Lcom/atlassian/onetime/service/TOTPService;", "totpGenerator", "Lcom/atlassian/onetime/core/TOTPGenerator;", "totpConfiguration", "Lcom/atlassian/onetime/service/TOTPConfiguration;", "(Lcom/atlassian/onetime/core/TOTPGenerator;Lcom/atlassian/onetime/service/TOTPConfiguration;)V", "generateTOTPUrl", "Ljava/net/URI;", "totpSecret", "Lcom/atlassian/onetime/model/TOTPSecret;", "emailAddress", "Lcom/atlassian/onetime/model/EmailAddress;", "issuer", "Lcom/atlassian/onetime/model/Issuer;", "verify", "Lcom/atlassian/onetime/service/TOTPVerificationResult;", "code", "Lcom/atlassian/onetime/core/TOTP;", "Companion", "onetime"})
public final class DefaultTOTPService
implements TOTPService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TOTPGenerator totpGenerator;
    @NotNull
    private final TOTPConfiguration totpConfiguration;
    @NotNull
    private static final String SCHEME = "otpauth";
    @NotNull
    private static final String TYPE = "totp";
    @NotNull
    private static final String SECRET_QUERY_PARAM = "secret";
    @NotNull
    private static final String ISSUER_QUERY_PARAM = "issuer";
    @NotNull
    private static final String ALGORITHM_QUERY_PARAM = "algorithm";
    @NotNull
    private static final String DIGITS_QUERY_PARAM = "digits";
    @NotNull
    private static final String PERIOD_QUERY_PARAM = "period";

    public DefaultTOTPService(@NotNull TOTPGenerator totpGenerator, @NotNull TOTPConfiguration totpConfiguration) {
        Intrinsics.checkNotNullParameter((Object)totpGenerator, (String)"totpGenerator");
        Intrinsics.checkNotNullParameter((Object)totpConfiguration, (String)"totpConfiguration");
        this.totpGenerator = totpGenerator;
        this.totpConfiguration = totpConfiguration;
    }

    public /* synthetic */ DefaultTOTPService(TOTPGenerator tOTPGenerator, TOTPConfiguration tOTPConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tOTPGenerator = new TOTPGenerator(null, 0, 0, null, null, 31, null);
        }
        if ((n & 2) != 0) {
            tOTPConfiguration = new TOTPConfiguration(0, 0, 3, null);
        }
        this(tOTPGenerator, tOTPConfiguration);
    }

    @Override
    @NotNull
    public URI generateTOTPUrl(@NotNull TOTPSecret totpSecret, @NotNull EmailAddress emailAddress, @NotNull Issuer issuer) {
        Intrinsics.checkNotNullParameter((Object)totpSecret, (String)"totpSecret");
        Intrinsics.checkNotNullParameter((Object)emailAddress, (String)"emailAddress");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)ISSUER_QUERY_PARAM);
        String encodedIssuer = TOTPServiceKt.urlEncode(issuer.getValue());
        String encodedEmailAddress = TOTPServiceKt.urlEncode(emailAddress.getValue());
        String template = "otpauth://totp/" + encodedIssuer + ':' + encodedEmailAddress + "?secret=" + totpSecret.getBase32Encoded() + "&issuer=" + encodedIssuer + "&algorithm=" + this.totpGenerator.getDigest().toQueryParam() + "&digits=" + this.totpGenerator.getOtpLength().getValue() + "&period=" + this.totpGenerator.getTimeStepSeconds();
        return new URI(template);
    }

    @Override
    @NotNull
    public TOTPVerificationResult verify(@NotNull TOTP code, @NotNull TOTPSecret totpSecret) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)totpSecret, (String)"totpSecret");
        int index = this.totpGenerator.generate(totpSecret, this.totpConfiguration.getAllowedPastSteps(), this.totpConfiguration.getAllowedFutureSteps()).indexOf(code);
        return index == -1 ? (TOTPVerificationResult)TOTPVerificationResult.InvalidTotp.INSTANCE : (TOTPVerificationResult)new TOTPVerificationResult.Success(index - this.totpConfiguration.getAllowedPastSteps());
    }

    public DefaultTOTPService() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/onetime/service/DefaultTOTPService$Companion;", "", "()V", "ALGORITHM_QUERY_PARAM", "", "DIGITS_QUERY_PARAM", "ISSUER_QUERY_PARAM", "PERIOD_QUERY_PARAM", "SCHEME", "SECRET_QUERY_PARAM", "TYPE", "onetime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

