package com.atlassian.plugins.osgi.javaconfig.conditions.product;

import com.atlassian.annotations.PublicApi;

/**
 * A Spring {@link org.springframework.context.annotation.Condition} that only returns <code>true</code> if the plugin
 * is running within Confluence.
 *
 * See the notes on the {@link JiraOnly} condition for typical usage scenarios.
 *
 * @since 0.1
 */
@PublicApi
public final class ConfluenceOnly extends AbstractProductCondition {

    /**
     * Constructor invoked reflectively by Spring.
     */
    public ConfluenceOnly() {
        super("com.atlassian.confluence.core.ContentEntityManager");
    }
}
