/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.util.ServletContextServletModuleManagerAccessor;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletModuleContainerServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ServletModuleContainerServlet.class);
    private ServletConfig servletConfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getServletModuleManager() == null) {
            log.error("Could not get ServletModuleManager?");
            response.sendError(500, "Could not get ServletModuleManager.");
            return;
        }
        HttpServlet servlet = this.getServletModuleManager().getServlet(this.getPathInfo(request), this.servletConfig);
        if (servlet == null) {
            log.debug("No servlet found for: " + this.getRequestURI(request));
            response.sendError(404, "Could not find servlet for: " + this.getRequestURI(request));
            return;
        }
        try {
            servlet.service((ServletRequest)request, (ServletResponse)response);
        }
        catch (UnavailableException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (ServletException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }

    protected ServletModuleManager getServletModuleManager() {
        return ServletContextServletModuleManagerAccessor.getServletModuleManager(this.getServletContext());
    }

    private String getPathInfo(HttpServletRequest request) {
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        if (pathInfo == null) {
            pathInfo = request.getPathInfo();
        }
        return pathInfo;
    }

    private String getRequestURI(HttpServletRequest request) {
        String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        }
        return requestURI;
    }
}

