/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.async;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginCssResourceParams;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResourceParams;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.atlassian.webresource.plugin.async.AsyncWebResourceLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWebResourceLoaderImpl
implements AsyncWebResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(AsyncWebResourceLoaderImpl.class);
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;

    public AsyncWebResourceLoaderImpl(WebResourceAssemblerFactory webResourceAssemblerFactory) {
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
    }

    @Override
    public AsyncWebResourceLoader.ResourcesAndData resolve(Set<String> webResources, Set<String> contexts, Set<String> excludeResources, Set<String> excludeContexts) throws IOException {
        WebResourceSet webResourceSet;
        ArrayList resources = Lists.newArrayList();
        LinkedHashMap data = Maps.newLinkedHashMap();
        LinkedHashMap errors = Maps.newLinkedHashMap();
        do {
            webResourceSet = this.resolveWebResourceSet(webResources, contexts, excludeResources, excludeContexts);
            for (WebResource webResource : webResourceSet.getResources()) {
                if (webResource instanceof PluginDataResource) {
                    PluginDataResource dataResource = (PluginDataResource)webResource;
                    Optional jsonable = dataResource.getData();
                    if (jsonable.isPresent()) {
                        data.put(dataResource.getKey(), AsyncWebResourceLoaderImpl.jsonToString(dataResource.getJsonable()));
                        continue;
                    }
                    errors.put(dataResource.getKey(), "\"\"");
                    continue;
                }
                if (webResource instanceof PluginJsResource) {
                    PluginJsResource jsResource = (PluginJsResource)webResource;
                    resources.add(new AsyncWebResourceLoader.Resource(jsResource.getStaticUrl(UrlMode.RELATIVE), AsyncWebResourceLoader.ResourceType.JAVASCRIPT, ((PluginJsResourceParams)jsResource.getParams()).conditionalComment(), ((PluginJsResourceParams)jsResource.getParams()).ieOnly(), null, jsResource.getKey(), jsResource.getBatchType()));
                    continue;
                }
                if (!(webResource instanceof PluginCssResource)) continue;
                PluginCssResource cssResource = (PluginCssResource)webResource;
                this.checkLogMediaQueryError(cssResource);
                resources.add(new AsyncWebResourceLoader.Resource(cssResource.getStaticUrl(UrlMode.RELATIVE), AsyncWebResourceLoader.ResourceType.CSS, ((PluginCssResourceParams)cssResource.getParams()).conditionalComment(), ((PluginCssResourceParams)cssResource.getParams()).ieOnly(), ((PluginCssResourceParams)cssResource.getParams()).media(), cssResource.getKey(), cssResource.getBatchType()));
            }
        } while (!webResourceSet.isComplete());
        return new AsyncWebResourceLoader.ResourcesAndData(resources, data, errors);
    }

    private static String jsonToString(Jsonable jsonable) throws IOException {
        StringWriter out = new StringWriter();
        jsonable.write((Writer)out);
        return out.toString();
    }

    private void checkLogMediaQueryError(PluginCssResource cssResource) {
        String media = ((PluginCssResourceParams)cssResource.getParams()).media();
        if (media != null && !media.isEmpty() && !"all".equals(media) && Boolean.parseBoolean(System.getProperty("atlassian.dev.mode"))) {
            logger.warn("WARN: asynchronously loading a CSS resource containing a media query: {}", (Object)cssResource.getStaticUrl(UrlMode.RELATIVE));
        }
    }

    private WebResourceSet resolveWebResourceSet(Set<String> webResources, Set<String> contexts, Set<String> excludeResources, Set<String> excludeContexts) {
        if (logger.isDebugEnabled()) {
            logger.debug("Requiring webresources {}", webResources);
            logger.debug("Requiring contexts {}", contexts);
            logger.debug("Excluding webresource {}", excludeResources);
            logger.debug("Excluding contexts {}", excludeContexts);
        }
        WebResourceAssembler assembler = this.webResourceAssemblerFactory.create().includeSuperbatchResources(false).build();
        assembler.resources().exclude(excludeResources, excludeContexts);
        for (String webResource : webResources) {
            if (Config.isWebResourceKey((String)webResource)) {
                assembler.resources().requireWebResource(webResource);
                continue;
            }
            assembler.resources().requireModule(webResource);
        }
        for (String context : contexts) {
            assembler.resources().requireContext(context);
        }
        return assembler.assembled().pollIncludedResources();
    }
}

