/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.prebake.discovery.RootPageCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuperBatchCrawler
implements WebResourceCrawler {
    private final Logger log = LoggerFactory.getLogger(RootPageCrawler.class);
    private final PrebakeWebResourceAssemblerFactory assemblerFactory;
    private final Dimensions valueWhitelist;

    public SuperBatchCrawler(PrebakeWebResourceAssemblerFactory assemblerFactory, Dimensions valueWhitelist) {
        this.assemblerFactory = assemblerFactory;
        this.valueWhitelist = valueWhitelist;
    }

    @Override
    public void crawl(BlockingQueue<Resource> queue) throws InterruptedException {
        this.log.debug("Getting resource URLS from Super Batch Crawler");
        Dimensions dims = this.assemblerFactory.computeDimensions().whitelistValues(this.valueWhitelist);
        this.log.debug("Current dimensions are:\n {}", (Object)dims.toString());
        this.log.debug("The size of the cartesian product is: {}", (Object)dims.cartesianProductSize());
        Iterator coords = dims.cartesianProduct().iterator();
        while (coords.hasNext()) {
            PrebakeWebResourceAssembler assembler = this.assemblerFactory.create().withCoordinate((Coordinate)coords.next()).build();
            this.crawlAssembledResource(assembler.assembled(), queue);
        }
    }

    @Override
    public List<String> getTargets() {
        return Collections.singletonList("superbatch");
    }
}

