/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.webresource.plugin.prebake.discovery.DiscoveryTask;
import com.atlassian.webresource.plugin.prebake.discovery.PreBakeState;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.ZipBundler;
import com.atlassian.webresource.plugin.prebake.exception.PreBakeIOException;
import com.atlassian.webresource.plugin.prebake.resources.ResourceCollector;
import com.atlassian.webresource.plugin.prebake.util.ConcurrentUtil;
import com.atlassian.webresource.plugin.prebake.util.StopWatch;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebResourcePreBaker {
    private static final Logger log = LoggerFactory.getLogger(WebResourcePreBaker.class);
    private final ExecutorService pool;
    private final Lock readState;
    private final Lock writeState;
    private final Config config;
    private final WebResourceIntegration webResourceIntegration;
    private final ResourceCollector resourceCollector;
    private PreBakeState state;
    private ZipBundler bundler;
    private List<String> targets;

    public WebResourcePreBaker(Config config, WebResourceIntegration webResourceIntegration, ResourceCollector resourceCollector) {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readState = rwl.readLock();
        this.writeState = rwl.writeLock();
        this.pool = Executors.newSingleThreadExecutor(ThreadFactories.named((String)"prebaker").type(ThreadFactories.Type.DAEMON).build());
        this.state = PreBakeState.NOTSTARTED;
        this.config = config;
        this.webResourceIntegration = webResourceIntegration;
        this.resourceCollector = resourceCollector;
    }

    public PreBakeStatus start(WebResourceCrawler ... crawlers) {
        return this.start(Arrays.asList(crawlers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreBakeStatus start(List<WebResourceCrawler> crawlers) {
        this.writeState.lock();
        try {
            if (this.state == PreBakeState.RUNNING) {
                PreBakeStatus preBakeStatus = this.getStatus();
                return preBakeStatus;
            }
            this.state = PreBakeState.RUNNING;
            this.doStart(crawlers);
            PreBakeStatus preBakeStatus = this.getStatus();
            return preBakeStatus;
        }
        catch (Exception e) {
            this.state = PreBakeState.CANCELLED;
            log.error("An error occurred while starting the prebake process", (Throwable)e);
            PreBakeStatus preBakeStatus = this.getStatus();
            return preBakeStatus;
        }
        finally {
            this.writeState.unlock();
        }
    }

    private void doStart(List<WebResourceCrawler> crawlers) {
        this.targets = new ArrayList<String>();
        for (WebResourceCrawler wrc : crawlers) {
            this.targets.addAll(wrc.getTargets());
        }
        this.bundler = this.createBundler();
        DiscoveryTask discoveryTask = new DiscoveryTask(this.config.ignorePrebakeWarnings(), this.config.isCSSPrebakingEnabled(), this.webResourceIntegration.getBaseUrl(UrlMode.RELATIVE), this.webResourceIntegration.getBaseUrl(UrlMode.ABSOLUTE), crawlers, this.resourceCollector, this.bundler);
        this.pool.execute(() -> {
            try {
                StopWatch stopwatch = new StopWatch();
                discoveryTask.doRun();
                this.bundler.createBundleZip();
                this.setState(PreBakeState.DONE);
                log.info("Total prebaking time: {}s", (Object)stopwatch.getElapsedSecondsAndReset());
            }
            catch (Exception e) {
                log.error("Cancelling pre-bake due to ", (Throwable)e);
                this.setState(PreBakeState.CANCELLED);
            }
        });
    }

    private ZipBundler createBundler() {
        String globalStateHash = this.config.computeGlobalStateHash();
        File tmp = this.webResourceIntegration.getTemporaryDirectory();
        Path outputFolder = Paths.get(tmp.getAbsolutePath(), globalStateHash);
        try {
            FileUtils.deleteDirectory((File)outputFolder.toFile());
            boolean created = outputFolder.toFile().mkdirs();
            if (!created) {
                String msg = String.format("Cannot create temporary folder '%s'", outputFolder.toString());
                throw new PreBakeIOException(msg);
            }
            return new ZipBundler(globalStateHash, outputFolder);
        }
        catch (IOException e) {
            String msg = String.format("Cannot clean temporary folder '%s'", outputFolder.toString());
            throw new PreBakeIOException(msg, e);
        }
    }

    private boolean setState(PreBakeState newState) {
        this.writeState.lock();
        try {
            if (this.state == newState) {
                boolean bl = false;
                return bl;
            }
            if (PreBakeState.CANCELLED == newState) {
                ConcurrentUtil.stopExecutor(this.pool, 200L);
            }
            this.state = newState;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeState.unlock();
        }
    }

    public PreBakeStatus getStatus() {
        this.readState.lock();
        try {
            PreBakeStatus preBakeStatus = new PreBakeStatus(this.state, this.bundler.getTaintedCount(), this.bundler.getGlobalStateHash(), this.bundler.getBundleZipPath(), this.targets);
            return preBakeStatus;
        }
        finally {
            this.readState.unlock();
        }
    }

    public static final class PreBakeStatus {
        private final PreBakeState state;
        private final int taintedResourceCount;
        private final String globalStateHash;
        private final Path bundlePath;
        private final List<String> targets;

        private PreBakeStatus(PreBakeState state, int taintedResourceCount, String globalStateHash, Path bundlePath, List<String> targets) {
            this.state = state;
            this.taintedResourceCount = taintedResourceCount;
            this.globalStateHash = globalStateHash;
            this.bundlePath = bundlePath;
            this.targets = Collections.unmodifiableList(new ArrayList<String>(targets));
        }

        public PreBakeState getState() {
            return this.state;
        }

        public int getTaintedResourceCount() {
            return this.taintedResourceCount;
        }

        public String getGlobalStateHash() {
            return this.globalStateHash;
        }

        public Path getBundlePath() {
            return this.bundlePath;
        }

        public List<String> getTargets() {
            return this.targets;
        }
    }
}

