/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.util;

import com.atlassian.webresource.plugin.prebake.util.ExceptionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConcurrentUtil {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentUtil.class);
    public static final long TIMEOUT = 3000L;

    private ConcurrentUtil() {
    }

    public static void stopExecutor(ExecutorService pool) {
        ConcurrentUtil.stopExecutor(pool, 3000L);
    }

    public static void stopExecutor(ExecutorService pool, long timeout) {
        if (pool != null) {
            pool.shutdown();
            try {
                if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                        log.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                ExceptionHandler.interruption(ie);
            }
        }
    }
}

