/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    private static final String DEFAULT_ERROR = "Something went wrong -> ";
    private static final String DEFAULT_INTERRUPTION_ERROR = "Was interrupted";

    private ExceptionHandler() {
    }

    public static void handle(String message, Throwable t) {
        log.error(message, t);
    }

    public static void interruption(String message, InterruptedException ie) {
        ExceptionHandler.handle(message, ie);
        Thread.currentThread().interrupt();
    }

    public static void interruption(InterruptedException ie) {
        ExceptionHandler.interruption(DEFAULT_INTERRUPTION_ERROR, ie);
    }

    public static void ex(String message, Throwable t) {
        if (t instanceof InterruptedException) {
            ExceptionHandler.interruption(message, (InterruptedException)t);
        } else {
            ExceptionHandler.handle(message, t);
        }
    }

    public static void ex(Throwable t) {
        if (t instanceof InterruptedException) {
            ExceptionHandler.interruption((InterruptedException)t);
        } else {
            ExceptionHandler.handle(DEFAULT_ERROR, t);
        }
    }
}

