/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ContextBatch;
import com.atlassian.plugin.webresource.ContextBatchOperations;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextBatchBuilder {
    private static final Logger log = LoggerFactory.getLogger(ContextBatchBuilder.class);
    private final PluginResourceLocator pluginResourceLocator;
    private final ResourceDependencyResolver dependencyResolver;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final List<String> allIncludedResources = Lists.newArrayList();
    private final Set<String> skippedResources = Sets.newHashSet();

    public ContextBatchBuilder(PluginResourceLocator pluginResourceLocator, ResourceDependencyResolver dependencyResolver, ResourceBatchingConfiguration batchingConfiguration) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.batchingConfiguration = batchingConfiguration;
    }

    public Iterable<PluginResource> build(List<String> includedContexts, Set<String> excludedContexts, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        return this.build(includedContexts, excludedContexts, DefaultWebResourceFilter.INSTANCE, conditionsRun, conditionsCache);
    }

    public Iterable<PluginResource> build(List<String> includedContexts, Set<String> excludedContexts, WebResourceFilter filter, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        if (this.batchingConfiguration.isContextBatchingEnabled()) {
            return this.buildBatched(includedContexts, excludedContexts, filter, conditionsRun, conditionsCache);
        }
        return this.getUnbatchedResources(includedContexts, excludedContexts, filter, conditionsRun, conditionsCache);
    }

    private Iterable<PluginResource> buildBatched(List<String> includedContexts, Set<String> excludedContexts, WebResourceFilter filter, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        HashSet incrementalExcludedContexts = null == excludedContexts ? Sets.newHashSet() : Sets.newHashSet(excludedContexts);
        HashSet conditionalIncludedResources = new HashSet();
        WebResourceKeysToContextBatches includedBatches = WebResourceKeysToContextBatches.create(includedContexts, this.dependencyResolver, this.pluginResourceLocator, filter, conditionsRun, conditionsCache);
        WebResourceKeysToContextBatches excludedBatches = WebResourceKeysToContextBatches.create(excludedContexts, this.dependencyResolver, this.pluginResourceLocator, filter, conditionsRun, conditionsCache);
        this.skippedResources.addAll(includedBatches.getSkippedResources());
        ArrayList batches = Lists.newArrayList();
        ArrayList batchesToProcess = Lists.newArrayList(includedBatches.getContextBatchKeys());
        HashSet superAlreadyProcessedBatches = Sets.newHashSet();
        ContextBatchOperations contextBatchOperations = new ContextBatchOperations(this.pluginResourceLocator, filter);
        while (!batchesToProcess.isEmpty()) {
            String resourceKey;
            String context = (String)batchesToProcess.remove(0);
            HashSet innerAlreadyProcessedBatches = Sets.newHashSet((Iterable)superAlreadyProcessedBatches);
            innerAlreadyProcessedBatches.add(context);
            ContextBatch mergedContextBatch = includedBatches.getContextBatch(context);
            if (!context.equals(DefaultResourceDependencyResolver.IMPLICIT_CONTEXT_NAME)) {
                Iterator<WebResourceModuleDescriptor> resourceIterator = mergedContextBatch.getResources().iterator();
                while (resourceIterator.hasNext()) {
                    WebResourceModuleDescriptor contextResource = resourceIterator.next();
                    resourceKey = contextResource.getCompleteKey();
                    Collection<ContextBatch> additionalContexts = includedBatches.getAdditionalContextsForResourceKey(resourceKey, innerAlreadyProcessedBatches);
                    if (additionalContexts.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        for (ContextBatch additionalContext : additionalContexts) {
                            log.debug("Context: {} shares a resource with {}: {}", (Object[])new String[]{mergedContextBatch.getKey(), additionalContext.getKey(), contextResource.getCompleteKey()});
                        }
                    }
                    ArrayList<ContextBatch> contextsToMerge = new ArrayList<ContextBatch>(1 + additionalContexts.size());
                    contextsToMerge.add(mergedContextBatch);
                    contextsToMerge.addAll(additionalContexts);
                    mergedContextBatch = contextBatchOperations.merge(contextsToMerge);
                    Collection additionalContextKeys = Collections2.transform(additionalContexts, (Function)new Function<ContextBatch, String>(){

                        public String apply(ContextBatch context) {
                            return context.getKey();
                        }
                    });
                    batchesToProcess.removeAll(additionalContextKeys);
                    innerAlreadyProcessedBatches.addAll(additionalContextKeys);
                    resourceIterator = mergedContextBatch.getResources().iterator();
                }
            }
            superAlreadyProcessedBatches.addAll(innerAlreadyProcessedBatches);
            if (!excludedBatches.isEmpty()) {
                for (WebResourceModuleDescriptor contextResource : mergedContextBatch.getResources()) {
                    resourceKey = contextResource.getCompleteKey();
                    Collection<ContextBatch> excludeContexts = excludedBatches.getContextsForResourceKey(resourceKey);
                    if (excludeContexts.isEmpty()) continue;
                    mergedContextBatch = contextBatchOperations.subtract(mergedContextBatch, excludeContexts, conditionsRun, conditionsCache);
                }
                this.skippedResources.removeAll(excludedBatches.getSkippedResources());
            }
            if (excludedBatches.isEmpty() || Iterables.size(mergedContextBatch.getResources()) != 0) {
                Iterables.addAll(this.allIncludedResources, mergedContextBatch.getResourceKeys());
                batches.add(mergedContextBatch);
            } else if (log.isDebugEnabled()) {
                log.debug("The context batch {} contains no resources so will be dropped.", (Object)mergedContextBatch.getKey());
            }
            incrementalExcludedContexts.addAll(mergedContextBatch.getContexts());
            excludedBatches = WebResourceKeysToContextBatches.create(incrementalExcludedContexts, this.dependencyResolver, this.pluginResourceLocator, filter, conditionsRun, conditionsCache);
        }
        final boolean resplitMergedBatches = this.batchingConfiguration.resplitMergedContextBatchesForThisRequest();
        return Iterables.concat((Iterable)Iterables.transform((Iterable)batches, (Function)new Function<ContextBatch, Iterable<PluginResource>>(){

            public Iterable<PluginResource> apply(ContextBatch batch) {
                return batch.buildPluginResources(resplitMergedBatches);
            }
        }));
    }

    private Iterable<PluginResource> getUnbatchedResources(Iterable<String> includedContexts, Iterable<String> excludedContexts, WebResourceFilter filter, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        HashSet<String> excludedResourceKeys = new HashSet<String>();
        HashSet<String> excludedSkippedResources = new HashSet<String>();
        if (excludedContexts != null && Iterables.size(excludedContexts) > 0) {
            for (String context : excludedContexts) {
                Iterable<WebResourceModuleDescriptor> contextResources = this.dependencyResolver.getDependenciesInContext(context, false, excludedSkippedResources, conditionsRun, conditionsCache);
                for (WebResourceModuleDescriptor contextResource : contextResources) {
                    excludedResourceKeys.add(contextResource.getCompleteKey());
                }
            }
        }
        LinkedHashSet<PluginResource> includedResources = new LinkedHashSet<PluginResource>();
        HashSet<String> includedSkippedResources = new HashSet<String>();
        for (String context : includedContexts) {
            Iterable<WebResourceModuleDescriptor> contextResources = this.dependencyResolver.getDependenciesInContext(context, false, includedSkippedResources, conditionsRun, conditionsCache);
            for (WebResourceModuleDescriptor contextResource : contextResources) {
                String completeKey = contextResource.getCompleteKey();
                if (excludedResourceKeys.contains(completeKey) || this.allIncludedResources.contains(completeKey)) continue;
                List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(contextResource.getCompleteKey(), conditionsRun, conditionsCache);
                for (PluginResource moduleResource : moduleResources) {
                    if (!filter.matches(moduleResource.getResourceName())) continue;
                    includedResources.add(moduleResource);
                }
                this.allIncludedResources.add(contextResource.getCompleteKey());
            }
        }
        includedSkippedResources.removeAll(excludedSkippedResources);
        this.skippedResources.addAll(includedSkippedResources);
        return includedResources;
    }

    public Iterable<String> getAllIncludedResources() {
        return this.allIncludedResources;
    }

    public Iterable<String> getSkippedResources() {
        return this.skippedResources;
    }

    private static class WebResourceKeysToContextBatches {
        private final ListMultimap<String, String> resourceToContextBatches;
        private final Map<String, ContextBatch> knownBatches;
        private final Set<String> skippedResources;

        static WebResourceKeysToContextBatches create(Iterable<String> contexts, ResourceDependencyResolver dependencyResolver, PluginResourceLocator pluginResourceLocator, WebResourceFilter filter, ConditionState conditionsRun, ConditionsCache conditionsCache) {
            ArrayListMultimap resourceKeyToContext = ArrayListMultimap.create();
            LinkedHashMap batches = Maps.newLinkedHashMap();
            HashSet skippedResources = Sets.newHashSet();
            if (null != contexts) {
                for (String context : contexts) {
                    Iterable<WebResourceModuleDescriptor> dependencies = dependencyResolver.getDependenciesInContext(context, false, skippedResources, conditionsRun, conditionsCache);
                    ContextBatch batch = new ContextBatch(pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt(), context, dependencies);
                    for (WebResourceModuleDescriptor moduleDescriptor : dependencies) {
                        String key = moduleDescriptor.getCompleteKey();
                        boolean matchedPluginResource = false;
                        for (PluginResource pluginResource : pluginResourceLocator.getPluginResources(moduleDescriptor.getCompleteKey(), conditionsRun, conditionsCache)) {
                            if (!filter.matches(pluginResource.getResourceName())) continue;
                            batch.addResourceType(pluginResource);
                            matchedPluginResource = true;
                        }
                        if (filter == DefaultWebResourceFilter.INSTANCE && !moduleDescriptor.getDataProviders().isEmpty()) {
                            matchedPluginResource = true;
                        }
                        if (!matchedPluginResource) continue;
                        resourceKeyToContext.put((Object)key, (Object)context);
                        batches.put(context, batch);
                    }
                }
            }
            return new WebResourceKeysToContextBatches((ListMultimap<String, String>)resourceKeyToContext, batches, skippedResources);
        }

        private WebResourceKeysToContextBatches(ListMultimap<String, String> resourceKeyToContext, Map<String, ContextBatch> allBatches, Set<String> skippedResources) {
            this.resourceToContextBatches = resourceKeyToContext;
            this.knownBatches = allBatches;
            this.skippedResources = skippedResources;
        }

        Collection<ContextBatch> getContextsForResourceKey(String key) {
            return this.getAdditionalContextsForResourceKey(key, null);
        }

        Collection<ContextBatch> getAdditionalContextsForResourceKey(String key, Collection<String> knownContexts) {
            List allContexts = this.resourceToContextBatches.get((Object)key);
            if (CollectionUtils.isEmpty((Collection)allContexts)) {
                return Collections.emptyList();
            }
            LinkedHashSet contexts = Sets.newLinkedHashSet((Iterable)allContexts);
            if (CollectionUtils.isNotEmpty(knownContexts)) {
                contexts.removeAll(knownContexts);
            }
            return Collections2.transform((Collection)contexts, (Function)new Function<String, ContextBatch>(){

                public ContextBatch apply(String context) {
                    return (ContextBatch)WebResourceKeysToContextBatches.this.knownBatches.get(context);
                }
            });
        }

        Iterable<String> getContextBatchKeys() {
            return this.knownBatches.keySet();
        }

        private ContextBatch getContextBatch(String context) {
            return this.knownBatches.get(context);
        }

        public Set<String> getSkippedResources() {
            return this.skippedResources;
        }

        boolean isEmpty() {
            return this.knownBatches.isEmpty();
        }
    }
}

