/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.security;

import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.plugins.rest.module.servlet.ServletUtils;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import java.security.Principal;

public class SalAuthenticationContext
implements AuthenticationContext {
    private final UserManager userManager;

    public SalAuthenticationContext(UserManager userManager) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    @Override
    public Principal getPrincipal() {
        String userName = this.getUserName();
        return userName != null ? new SalPrincipal(userName) : null;
    }

    @Override
    public boolean isAuthenticated() {
        return this.getUserName() != null;
    }

    private String getUserName() {
        return this.userManager.getRemoteUsername(ServletUtils.getHttpServletRequest());
    }

    private static class SalPrincipal
    implements Principal {
        private final String userName;

        SalPrincipal(String userName) {
            this.userName = (String)Preconditions.checkNotNull((Object)userName);
        }

        @Override
        public String getName() {
            return this.userName;
        }

        @Override
        public int hashCode() {
            return this.userName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj != null && obj instanceof SalPrincipal && ((SalPrincipal)obj).userName.equals(this.userName);
        }

        @Override
        public String toString() {
            return this.userName;
        }
    }
}

