/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.engine.ValidatorContextImpl;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.xml.XmlMappingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFactoryImpl
implements ValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.constraintHelper = new ConstraintHelper();
        this.beanMetaDataCache = new BeanMetaDataCache();
        this.initBeanMetaData(configurationState.getMappingStreams());
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        throw new ValidationException("Type " + type + " not supported");
    }

    public ValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache);
    }

    private <T> void initBeanMetaData(Set<InputStream> mappingStreams) {
        XmlMappingParser mappingParser = new XmlMappingParser(this.constraintHelper);
        mappingParser.parse(mappingStreams);
        Set<Class<?>> processedClasses = mappingParser.getProcessedClasses();
        AnnotationIgnores annotationIgnores = mappingParser.getAnnotationIgnores();
        Iterator<Class<?>> i$ = processedClasses.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, annotationIgnores, this.beanMetaDataCache);
            ArrayList classes = new ArrayList();
            ReflectionHelper.computeClassHierarchy(beanClass, classes);
            for (Class clazz2 : classes) {
                if (!processedClasses.contains(clazz2)) continue;
                this.addXmlConfiguredConstraintToMetaData(mappingParser, beanClass, clazz2, metaData);
            }
            if (!mappingParser.getDefaultSequenceForClass(beanClass).isEmpty()) {
                metaData.setDefaultGroupSequence(mappingParser.getDefaultSequenceForClass(beanClass));
            }
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T, A extends Annotation> void addXmlConfiguredConstraintToMetaData(XmlMappingParser mappingParser, Class<T> rootClass, Class<?> hierarchyClass, BeanMetaDataImpl<T> metaData) {
        for (MetaConstraint<?, Annotation> constraint : mappingParser.getConstraintsForClass(hierarchyClass)) {
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl<Annotation> descriptor = new ConstraintDescriptorImpl<Annotation>(constraint.getDescriptor().getAnnotation(), this.constraintHelper, constraint.getElementType(), definedIn);
            MetaConstraint<T, Annotation> newMetaConstraint = new MetaConstraint<T, Annotation>(rootClass, constraint.getMember(), descriptor);
            metaData.addMetaConstraint(hierarchyClass, newMetaConstraint);
        }
        for (Member m : mappingParser.getCascadedMembersForClass(hierarchyClass)) {
            metaData.addCascadedMember(m);
        }
    }

    private ConstraintOrigin definedIn(Class<?> rootClass, Class<?> hierarchyClass) {
        if (hierarchyClass.equals(rootClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }
}

