/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.sal.api.features.InvalidFeatureKeyException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public enum ValidFeatureKeyPredicate implements Predicate<String>
{
    INSTANCE;

    private static final Pattern VALID_FEATURE_KEY_PATTERN;

    public static boolean isValidFeatureKey(@Nullable String input) {
        return INSTANCE.test(input);
    }

    public static String checkFeatureKey(@Nullable String input) {
        if (ValidFeatureKeyPredicate.isValidFeatureKey(input)) {
            return input;
        }
        throw new InvalidFeatureKeyException("Invalid feature key: '" + input + "'");
    }

    @Override
    public boolean test(@Nullable String input) {
        return input != null && VALID_FEATURE_KEY_PATTERN.matcher(input).matches();
    }

    static {
        VALID_FEATURE_KEY_PATTERN = Pattern.compile("[\\w\\.\\-]+");
    }
}

