/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.testresources.net;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.testresources.net.MockResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockRequest
implements Request<MockRequest, MockResponse> {
    private final Request.MethodType methodType;
    private String url;
    private int connectionTimeout;
    private int soTimeout;
    private String requestBody;
    private String requestContentType;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final List<String> requestParameters = new ArrayList<String>();
    private String basicHost;
    private String basicUser;
    private String basicPassword;
    private MockResponse response;
    private String responseBody;
    private boolean followRedirects = true;

    public MockRequest(Request.MethodType methodType, String url) {
        this.methodType = methodType;
        this.url = url;
    }

    public MockRequest setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public MockRequest setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public MockRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public MockRequest setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public MockRequest setRequestBody(String requestBody, String contentType) {
        this.requestBody = requestBody;
        this.requestContentType = contentType;
        return this;
    }

    public MockRequest setFiles(List<RequestFilePart> files) {
        return null;
    }

    public MockRequest setEntity(Object entity) {
        throw new UnsupportedOperationException();
    }

    public MockRequest setRequestContentType(String contentType) {
        this.requestContentType = contentType;
        return this;
    }

    public MockRequest addRequestParameters(String ... params) {
        this.requestParameters.addAll(Arrays.asList(params));
        return this;
    }

    public MockRequest addHeader(String headerName, String headerValue) {
        List<String> list = this.headers.get(headerName);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(headerName, list);
        }
        list.add(headerValue);
        return this;
    }

    public MockRequest setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, new ArrayList<String>(Arrays.asList(headerValue)));
        return this;
    }

    public MockRequest setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    public MockRequest addBasicAuthentication(String host, String username, String password) {
        this.basicHost = host;
        this.basicUser = username;
        this.basicPassword = password;
        return this;
    }

    public <RET> RET executeAndReturn(ReturningResponseHandler<? super MockResponse, RET> responseHandler) throws ResponseException {
        if (this.response == null) {
            this.response = new MockResponse();
        }
        return (RET)responseHandler.handle((Response)this.response);
    }

    public void execute(ResponseHandler<? super MockResponse> responseHandler) throws ResponseException {
        if (this.response == null) {
            this.response = new MockResponse();
        }
        responseHandler.handle((Response)this.response);
    }

    public String execute() throws ResponseException {
        return this.responseBody;
    }

    public Request.MethodType getMethodType() {
        return this.methodType;
    }

    public String getUrl() {
        return this.url;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public List<String> getRequestParameters() {
        return this.requestParameters;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public String getBasicHost() {
        return this.basicHost;
    }

    public String getBasicUser() {
        return this.basicUser;
    }

    public String getBasicPassword() {
        return this.basicPassword;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(MockResponse response) {
        this.response = response;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }
}

