/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.quartz2.Quartz2HardenedJobStore;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;

public class Quartz2DefaultSettingsFactory {
    private static final ImmutableMap<String, String> DEFAULT_LOCAL_CONFIG = ImmutableMap.builder().put((Object)"org.quartz.jobStore.class", (Object)RAMJobStore.class.getName()).put((Object)"org.quartz.scheduler.instanceName", (Object)"atlassian-scheduler-quartz2.local").put((Object)"org.quartz.scheduler.skipUpdateCheck", (Object)"true").put((Object)"org.quartz.threadPool.class", (Object)SimpleThreadPool.class.getName()).put((Object)"org.quartz.threadPool.threadCount", (Object)"4").put((Object)"org.quartz.threadPool.threadPriority", (Object)"4").build();
    private static final ImmutableMap<String, String> DEFAULT_CLUSTERED_CONFIG = ImmutableMap.builder().put((Object)"org.quartz.jobStore.class", (Object)Quartz2HardenedJobStore.class.getName()).put((Object)"org.quartz.jobStore.isClustered", (Object)"true").put((Object)"org.quartz.scheduler.instanceName", (Object)"atlassian-scheduler-quartz2.clustered").put((Object)"org.quartz.scheduler.skipUpdateCheck", (Object)"true").put((Object)"org.quartz.threadPool.class", (Object)SimpleThreadPool.class.getName()).put((Object)"org.quartz.threadPool.threadCount", (Object)"4").put((Object)"org.quartz.threadPool.threadPriority", (Object)"4").build();

    public static Properties getDefaultLocalSettings() {
        return Quartz2DefaultSettingsFactory.toProperties(DEFAULT_LOCAL_CONFIG);
    }

    public static Properties getDefaultClusteredSettings() {
        return Quartz2DefaultSettingsFactory.toProperties(DEFAULT_CLUSTERED_CONFIG);
    }

    private static Properties toProperties(Map<String, String> defaultConfig) {
        Properties config = new Properties();
        for (Map.Entry<String, String> entry : defaultConfig.entrySet()) {
            config.setProperty(entry.getKey(), entry.getValue());
        }
        return config;
    }
}

