/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.core.util.LogWarn;
import java.sql.Connection;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quartz2HardenedJobStore
extends JobStoreTX {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz2HardenedJobStore.class);
    private final ReentrantLock recoverJobsLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverJobs() throws JobPersistenceException {
        this.recoverJobsLock.lock();
        try {
            super.recoverJobs();
        }
        finally {
            this.recoverJobsLock.unlock();
        }
    }

    protected void storeTrigger(Connection conn, OperableTrigger newTrigger, @Nullable JobDetail job, boolean replaceExisting, String state, boolean forceState, boolean recovering) throws JobPersistenceException {
        try {
            super.storeTrigger(conn, newTrigger, job, replaceExisting, state, forceState, recovering);
        }
        catch (JobPersistenceException jpe) {
            if (!this.recoverJobsLock.isHeldByCurrentThread()) {
                throw jpe;
            }
            LogWarn.logWarn((Logger)LOG, (String)"Caught an exception storing trigger during scheduler recovery", (Throwable)jpe);
        }
    }
}

