/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.core.status.AbstractJobDetailsFactory;
import com.atlassian.scheduler.quartz2.Quartz2SchedulerService;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class Quartz2JobDetailsFactory
extends AbstractJobDetailsFactory<Trigger> {
    Quartz2JobDetailsFactory(Quartz2SchedulerService schedulerService) {
        super((AbstractSchedulerService)schedulerService);
    }

    @Nonnull
    protected JobRunnerKey getJobRunnerKey(Trigger trigger) {
        return JobRunnerKey.of((String)trigger.getJobKey().getName());
    }

    @Nonnull
    protected Schedule getSchedule(Trigger trigger) {
        if (trigger instanceof CronTrigger) {
            CronTrigger cron = (CronTrigger)trigger;
            return Schedule.forCronExpression((String)cron.getCronExpression(), (TimeZone)cron.getTimeZone());
        }
        if (trigger instanceof SimpleTrigger) {
            SimpleTrigger simple = (SimpleTrigger)trigger;
            return Schedule.forInterval((long)simple.getRepeatInterval(), (Date)simple.getStartTime());
        }
        throw new SchedulerRuntimeException("The job with jobId '" + trigger.getKey().getName() + "' has an unsupported trigger class: " + trigger.getClass().getName());
    }

    @Nullable
    protected byte[] getSerializedParameters(Trigger trigger) {
        return (byte[])trigger.getJobDataMap().get((Object)"parameters");
    }

    @Nullable
    protected Date getNextRunTime(Trigger trigger) {
        return trigger.getNextFireTime();
    }
}

