/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.quartz2.Quartz2Job;
import com.atlassian.util.concurrent.Assertions;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

class Quartz2JobFactory
extends SimpleJobFactory
implements JobFactory {
    private final AbstractSchedulerService schedulerService;
    private final RunMode schedulerRunMode;

    Quartz2JobFactory(AbstractSchedulerService schedulerService, RunMode schedulerRunMode) {
        this.schedulerService = (AbstractSchedulerService)Assertions.notNull((String)"schedulerService", (Object)schedulerService);
        this.schedulerRunMode = (RunMode)Assertions.notNull((String)"schedulerRunMode", (Object)schedulerRunMode);
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        if (Quartz2Job.class.equals((Object)jobDetail.getJobClass())) {
            return new Quartz2Job(this.schedulerService, this.schedulerRunMode, bundle);
        }
        return new ClassLoaderProtectingWrappedJob(super.newJob(bundle, scheduler), this.schedulerService);
    }

    static class ClassLoaderProtectingWrappedJob
    implements Job {
        private final Job delegate;
        private final AbstractSchedulerService service;

        ClassLoaderProtectingWrappedJob(Job delegate, AbstractSchedulerService service) {
            this.service = service;
            this.delegate = (Job)Assertions.notNull((String)"delegate", (Object)delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecutionContext context) throws JobExecutionException {
            this.service.preJob();
            Thread thd = Thread.currentThread();
            ClassLoader originalClassLoader = thd.getContextClassLoader();
            try {
                thd.setContextClassLoader(this.delegate.getClass().getClassLoader());
                this.delegate.execute(context);
            }
            finally {
                thd.setContextClassLoader(originalClassLoader);
                this.service.postJob();
            }
        }
    }
}

