/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.quartz2.Quartz2Job;
import com.atlassian.scheduler.quartz2.Quartz2JobFactory;
import com.atlassian.scheduler.quartz2.spi.Quartz2SchedulerConfiguration;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Quartz2SchedulerFacade {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz2SchedulerFacade.class);
    static final String QUARTZ_JOB_GROUP = "SchedulerServiceJobs";
    static final String QUARTZ_TRIGGER_GROUP = "SchedulerServiceTriggers";
    static final String QUARTZ_PARAMETERS_KEY = "parameters";
    private final Supplier<Scheduler> quartzRef;

    private Quartz2SchedulerFacade(Supplier<Scheduler> quartzRef) {
        this.quartzRef = quartzRef;
    }

    static Quartz2SchedulerFacade createLocal(AbstractSchedulerService schedulerService, Scheduler scheduler) throws SchedulerServiceException {
        Assertions.notNull((String)"scheduler", (Object)scheduler);
        return Quartz2SchedulerFacade.createFacade(schedulerService, scheduler, RunMode.RUN_LOCALLY);
    }

    static Quartz2SchedulerFacade createClustered(AbstractSchedulerService schedulerService, Scheduler scheduler) throws SchedulerServiceException {
        Assertions.notNull((String)"scheduler", (Object)scheduler);
        return Quartz2SchedulerFacade.createFacade(schedulerService, scheduler, RunMode.RUN_ONCE_PER_CLUSTER);
    }

    private static Quartz2SchedulerFacade createFacade(AbstractSchedulerService schedulerService, Scheduler scheduler, RunMode runMode) throws SchedulerServiceException {
        try {
            Quartz2SchedulerFacade.configureScheduler(scheduler, schedulerService, runMode);
            Supplier quartzRef = Suppliers.ofInstance((Object)scheduler);
            return new Quartz2SchedulerFacade((Supplier<Scheduler>)quartzRef);
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.checked("Unable to configure the underlying Quartz scheduler", se);
        }
    }

    static Quartz2SchedulerFacade createLocal(AbstractSchedulerService schedulerService, Quartz2SchedulerConfiguration config) throws SchedulerServiceException {
        Assertions.notNull((String)"config", (Object)config);
        Properties localSettings = (Properties)Assertions.notNull((String)"config.getLocalSettings()", (Object)config.getLocalSettings());
        return Quartz2SchedulerFacade.createFacade(schedulerService, localSettings, RunMode.RUN_LOCALLY);
    }

    static Quartz2SchedulerFacade createClustered(AbstractSchedulerService schedulerService, Quartz2SchedulerConfiguration config) throws SchedulerServiceException {
        Assertions.notNull((String)"config", (Object)config);
        Properties clusteredSettings = (Properties)Assertions.notNull((String)"config.getClusteredSettings()", (Object)config.getClusteredSettings());
        return Quartz2SchedulerFacade.createFacade(schedulerService, clusteredSettings, RunMode.RUN_ONCE_PER_CLUSTER);
    }

    private static Quartz2SchedulerFacade createFacade(AbstractSchedulerService schedulerService, Properties customConfig, RunMode runMode) throws SchedulerServiceException {
        try {
            Properties config = new Properties();
            for (String key : customConfig.stringPropertyNames()) {
                config.setProperty(key, customConfig.getProperty(key));
            }
            config.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(config);
            Supplier<Scheduler> quartzRef = Quartz2SchedulerFacade.createQuartzRef(schedulerService, runMode, schedulerFactory);
            return new Quartz2SchedulerFacade(quartzRef);
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.checked("Unable to create the underlying Quartz scheduler", se);
        }
    }

    private static Supplier<Scheduler> createQuartzRef(final AbstractSchedulerService schedulerService, final RunMode runMode, final StdSchedulerFactory schedulerFactory) {
        return new LazyReference<Scheduler>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Scheduler create() throws Exception {
                Thread thd = Thread.currentThread();
                ClassLoader originalContextClassLoader = thd.getContextClassLoader();
                try {
                    thd.setContextClassLoader(schedulerService.getClass().getClassLoader());
                    Scheduler quartz = schedulerFactory.getScheduler();
                    Quartz2SchedulerFacade.configureScheduler(quartz, schedulerService, runMode);
                    Scheduler scheduler = quartz;
                    return scheduler;
                }
                finally {
                    thd.setContextClassLoader(originalContextClassLoader);
                }
            }
        };
    }

    static void configureScheduler(Scheduler quartz, AbstractSchedulerService schedulerService, RunMode runMode) throws SchedulerException {
        quartz.setJobFactory((JobFactory)new Quartz2JobFactory(schedulerService, runMode));
    }

    @Nullable
    Trigger getTrigger(JobId jobId) {
        try {
            return this.getScheduler().getTrigger(Quartz2SchedulerFacade.jobId(jobId));
        }
        catch (SchedulerException se) {
            Quartz2SchedulerFacade.logWarn("Error getting quartz trigger for '{}'", jobId, se);
            return null;
        }
    }

    @Nullable
    JobDetail getQuartzJob(JobRunnerKey jobRunnerKey) {
        try {
            return this.getScheduler().getJobDetail(Quartz2SchedulerFacade.jobRunnerKey(jobRunnerKey));
        }
        catch (SchedulerException se) {
            Quartz2SchedulerFacade.logWarn("Error getting quartz job details for '{}'", jobRunnerKey, se);
            return null;
        }
    }

    boolean hasAnyTriggers(JobRunnerKey jobRunnerKey) {
        return !this.getTriggersOfJob(jobRunnerKey).isEmpty();
    }

    Collection<JobRunnerKey> getJobRunnerKeys() {
        try {
            Set jobKeys = this.getScheduler().getJobKeys(GroupMatcher.jobGroupEquals((String)QUARTZ_JOB_GROUP));
            HashSet<JobRunnerKey> jobRunnerKeys = new HashSet<JobRunnerKey>((int)((double)jobKeys.size() * 1.25));
            for (JobKey jobKey : jobKeys) {
                jobRunnerKeys.add(JobRunnerKey.of((String)jobKey.getName()));
            }
            return jobRunnerKeys;
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.unchecked("Could not get the triggers from Quartz", se);
        }
    }

    List<? extends Trigger> getTriggersOfJob(JobRunnerKey jobRunnerKey) {
        try {
            return this.getScheduler().getTriggersOfJob(Quartz2SchedulerFacade.jobRunnerKey(jobRunnerKey));
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.unchecked("Could not get the triggers from Quartz", se);
        }
    }

    boolean deleteTrigger(JobId jobId) {
        try {
            return this.getScheduler().unscheduleJob(Quartz2SchedulerFacade.jobId(jobId));
        }
        catch (SchedulerException se) {
            Quartz2SchedulerFacade.logWarn("Error removing Quartz trigger for '{}'", jobId, se);
            return false;
        }
    }

    boolean deleteJob(JobRunnerKey jobRunnerKey) {
        try {
            return this.getScheduler().deleteJob(Quartz2SchedulerFacade.jobRunnerKey(jobRunnerKey));
        }
        catch (SchedulerException se) {
            Quartz2SchedulerFacade.logWarn("Error removing Quartz job for '{}'", jobRunnerKey, se);
            return false;
        }
    }

    private void scheduleJob(TriggerBuilder<?> trigger) throws SchedulerServiceException {
        try {
            this.getScheduler().scheduleJob(trigger.build());
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.checked("Unable to create the Quartz trigger", se);
        }
    }

    void scheduleJob(JobRunnerKey jobRunnerKey, TriggerBuilder<?> trigger) throws SchedulerServiceException {
        if (this.getQuartzJob(jobRunnerKey) != null) {
            this.scheduleJob(trigger.forJob(Quartz2SchedulerFacade.jobRunnerKey(jobRunnerKey)));
            return;
        }
        try {
            JobDetail quartzJob = JobBuilder.newJob().withIdentity(Quartz2SchedulerFacade.jobRunnerKey(jobRunnerKey)).ofType(Quartz2Job.class).storeDurably(false).build();
            this.getScheduler().scheduleJob(quartzJob, trigger.build());
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.checked("Unable to create the Quartz job and trigger", se);
        }
    }

    boolean unscheduleJob(JobId jobId) {
        Trigger trigger = this.getTrigger(jobId);
        if (trigger == null) {
            return false;
        }
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)trigger.getJobKey().getName());
        if (this.deleteTrigger(jobId) && !this.hasAnyTriggers(jobRunnerKey)) {
            this.deleteJob(jobRunnerKey);
        }
        return true;
    }

    void start() throws SchedulerServiceException {
        try {
            this.getScheduler().start();
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.checked("Quartz scheduler refused to start", se);
        }
    }

    void standby() throws SchedulerServiceException {
        try {
            this.getScheduler().standby();
        }
        catch (SchedulerException se) {
            throw Quartz2SchedulerFacade.checked("Quartz scheduler refused to enter standby mode", se);
        }
    }

    void shutdown() {
        try {
            this.getScheduler().shutdown();
        }
        catch (SchedulerException se) {
            LOG.error("Error shutting down internal scheduler", (Throwable)se);
        }
    }

    private Scheduler getScheduler() {
        try {
            return (Scheduler)this.quartzRef.get();
        }
        catch (LazyReference.InitializationException ex) {
            throw Quartz2SchedulerFacade.unchecked("Error creating underlying Quartz scheduler", ex.getCause());
        }
    }

    private static void logWarn(String message, Object arg, Throwable e) {
        if (LOG.isDebugEnabled()) {
            LOG.warn(message, arg, (Object)e);
        } else {
            LOG.warn(message + ": {}", arg, (Object)e.toString());
        }
    }

    static TriggerKey jobId(JobId jobId) {
        return TriggerKey.triggerKey((String)jobId.toString(), (String)QUARTZ_TRIGGER_GROUP);
    }

    static JobKey jobRunnerKey(JobRunnerKey jobRunnerKey) {
        return JobKey.jobKey((String)jobRunnerKey.toString(), (String)QUARTZ_JOB_GROUP);
    }

    private static SchedulerServiceException checked(String message, Throwable e) {
        return new SchedulerServiceException(message, e);
    }

    private static SchedulerRuntimeException unchecked(String message, Throwable e) {
        return new SchedulerRuntimeException(message, e);
    }
}

