/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz2;

import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.CronScheduleInfo;
import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.spi.SchedulerServiceConfiguration;
import com.atlassian.scheduler.core.util.CronExpressionQuantizer;
import com.atlassian.scheduler.core.util.ParameterMapSerializer;
import com.atlassian.scheduler.core.util.QuartzParseExceptionMapper;
import com.atlassian.scheduler.core.util.TimeIntervalQuantizer;
import com.atlassian.scheduler.cron.CronSyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

class Quartz2TriggerFactory {
    private final SchedulerServiceConfiguration config;
    private final ParameterMapSerializer parameterMapSerializer;

    Quartz2TriggerFactory(SchedulerServiceConfiguration config, ParameterMapSerializer parameterMapSerializer) {
        this.config = config;
        this.parameterMapSerializer = parameterMapSerializer;
    }

    public TriggerBuilder<?> buildTrigger(JobId jobId, JobConfig jobConfig) throws SchedulerServiceException {
        byte[] parameters = this.parameterMapSerializer.serializeParameters(jobConfig.getParameters());
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("parameters", (Object)parameters);
        return this.buildTrigger(jobConfig.getSchedule()).withIdentity(TriggerKey.triggerKey((String)jobId.toString(), (String)"SchedulerServiceTriggers")).usingJobData(jobDataMap);
    }

    public TriggerBuilder<?> buildTrigger(Schedule schedule) throws SchedulerServiceException {
        switch (schedule.getType()) {
            case INTERVAL: {
                return Quartz2TriggerFactory.getSimpleTrigger(schedule.getIntervalScheduleInfo());
            }
            case CRON_EXPRESSION: {
                return this.getCronTrigger(schedule.getCronScheduleInfo());
            }
        }
        throw new IllegalStateException("type=" + schedule.getType());
    }

    private static TriggerBuilder<SimpleTrigger> getSimpleTrigger(IntervalScheduleInfo info) {
        Date startTime = info.getFirstRunTime() != null ? info.getFirstRunTime() : new Date();
        return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)Quartz2TriggerFactory.interval(info.getIntervalInMillis())).startAt(startTime);
    }

    private static SimpleScheduleBuilder interval(long intervalInMillis) {
        if (intervalInMillis == 0L) {
            return SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(TimeIntervalQuantizer.quantizeToMinutes((long)intervalInMillis)).repeatForever();
    }

    private TriggerBuilder<CronTrigger> getCronTrigger(CronScheduleInfo info) throws CronSyntaxException {
        try {
            String cronExpression = new CronExpression(info.getCronExpression()).getCronExpression();
            CronScheduleBuilder schedule = CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)CronExpressionQuantizer.quantizeSecondsField((String)cronExpression)).inTimeZone(this.getTimeZone(info));
            return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)schedule);
        }
        catch (ParseException pe) {
            throw QuartzParseExceptionMapper.mapException((String)info.getCronExpression().toUpperCase(Locale.US), (ParseException)pe);
        }
    }

    @Nonnull
    private TimeZone getTimeZone(CronScheduleInfo info) {
        TimeZone timeZone = info.getTimeZone();
        if (timeZone == null && (timeZone = this.config.getDefaultTimeZone()) == null) {
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }
}

