/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.spring.filter;

import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.support.OpenSessionInViewFilter;

public class FlushingSpringSessionInViewFilter
extends OpenSessionInViewFilter {
    public static final Category log = Category.getInstance(FlushingSpringSessionInViewFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!ContainerManager.isContainerSetup() || !this.isDatabaseSetUp()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        super.doFilterInternal(request, response, filterChain);
    }

    protected boolean isDatabaseSetUp() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSession(Session session, SessionFactory sessionFactory) {
        if (session != null && session.isOpen() && session.isConnected()) {
            try {
                session.flush();
            }
            catch (Exception e) {
                log.error((Object)("Unable to flush Hibernate session. Possible data loss: " + e.getMessage()), (Throwable)e);
            }
            finally {
                super.closeSession(session, sessionFactory);
            }
        }
    }
}

