/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.allowlist.uberspect;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.velocity.allowlist.api.internal.PluginAllowlist;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.introspection.SecureIntrospectorImpl;

public class PluginAwareSecureIntrospector
extends SecureIntrospectorImpl {
    public static final String ALLOWLIST_DEBUG_PROPERTY = "atlassian.velocity.method.allowlist.debug";
    public static final String ALLOWLIST_DEBUG_PROPERTY_ALT = "atlassian.plugins.velocity.method.allowlist.debug";
    private final boolean allowlistDebugMode = Boolean.getBoolean("atlassian.velocity.method.allowlist.debug") || Boolean.getBoolean("atlassian.plugins.velocity.method.allowlist.debug");
    private PluginAllowlist pluginAllowlist;
    private volatile ClassLoader pluginClassLoader;
    private final AtomicBoolean isPluginFrameworkStarted = new AtomicBoolean();

    public PluginAwareSecureIntrospector(Log log, RuntimeServices runtimeServices) {
        super(log, runtimeServices);
    }

    public void setPluginAllowlist(PluginAllowlist pluginAllowlist) {
        this.pluginAllowlist = pluginAllowlist;
    }

    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.pluginClassLoader != null) {
                return this.pluginClassLoader.loadClass(name);
            }
            throw e;
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.pluginClassLoader = event.getPluginAccessor().getClassLoader();
        this.isPluginFrameworkStarted.set(true);
    }

    protected boolean isIntrospectorEnabled() {
        return this.isPluginFrameworkStarted.get();
    }

    protected boolean isAllowlistDebugMode() {
        return super.isAllowlistDebugMode() || this.allowlistDebugMode;
    }

    protected boolean isAllowlistedClassPackageCached(Class<?> clazz) {
        return super.isAllowlistedClassPackageCached(clazz) || this.pluginAllowlist != null && this.pluginAllowlist.isAllowlistedClassPackage(clazz);
    }

    protected boolean isAllowlistedMethodCached(Method method) {
        return super.isAllowlistedMethodCached(method) || this.pluginAllowlist != null && this.pluginAllowlist.isAllowlistedMethod(method);
    }
}

