/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum AtlassianCertificate {
    MARKETPLACE_STAGING_ROOT("atl_root_dev.pem", AtlassianCertificate.format("MIIBzjCCAYCgAwIBAgIUcdrM45sJOTHrr+6+pJCPVlhuZA4wBQYDK2VwMFsxCzAJ\nBgNVBAYTAkFVMQwwCgYDVQQIDANOU1cxDzANBgNVBAcMBlN5ZG5leTEtMCsGA1UE\nAwwkQXRsYXNzaWFuIEFTIFJvb3QgQ0EgREVWIE5PX1BST0RfVVNFMB4XDTI0MDgy\nMTA3NTAxM1oXDTI5MDgyMTA3NTAxM1owWzELMAkGA1UEBhMCQVUxDDAKBgNVBAgM\nA05TVzEPMA0GA1UEBwwGU3lkbmV5MS0wKwYDVQQDDCRBdGxhc3NpYW4gQVMgUm9v\ndCBDQSBERVYgTk9fUFJPRF9VU0UwKjAFBgMrZXADIQDzgOHHlhFSUCVdcClpjeRV\nkk4kQdInbjT27dXxmvzthKNWMFQwHQYDVR0OBBYEFOdf2y5SEJ0k3D22x5XuXPEe\nySwBMB8GA1UdIwQYMBaAFOdf2y5SEJ0k3D22x5XuXPEeySwBMBIGA1UdEwEB/wQI\nMAYBAf8CAQEwBQYDK2VwA0EA1t7/meNg+do0SbD8knmPmH547ck1dYMaJex48Y7+\nipJx2We6vMc6zFESw2r5BYsR7zc2762YyzVjpvkVMLrqBQ==\n")),
    MARKETPLACE_STAGING_INTERMEDIATE("atl_intermediate_dev.pem", AtlassianCertificate.format("MIIB1jCCAYigAwIBAgIUGbYjRrIDwTIC/l8Oy7rIChPGxiswBQYDK2VwMFsxCzAJ\nBgNVBAYTAkFVMQwwCgYDVQQIDANOU1cxDzANBgNVBAcMBlN5ZG5leTEtMCsGA1UE\nAwwkQXRsYXNzaWFuIEFTIFJvb3QgQ0EgREVWIE5PX1BST0RfVVNFMB4XDTI0MDgy\nMTA3NTE1OFoXDTI1MDgyMTA3NTE1OFowYzELMAkGA1UEBhMCQVUxDDAKBgNVBAgM\nA05TVzEPMA0GA1UEBwwGU3lkbmV5MTUwMwYDVQQDDCxBdGxhc3NpYW4gQVMgSW50\nZXJtZWRpYXRlIENBIERFViBOT19QUk9EX1VTRTAqMAUGAytlcAMhAIn2HkyfIoj9\nMnKAg4e9oc5VGObyP7VuoKHhHcsUwAXWo1YwVDAdBgNVHQ4EFgQUtNdUFB1fZkkD\nd2hmCbSjEIJpccMwHwYDVR0jBBgwFoAU51/bLlIQnSTcPbbHle5c8R7JLAEwEgYD\nVR0TAQH/BAgwBgEB/wIBADAFBgMrZXADQQC+ZrltqsK70pD5W98FK/GMhePW3E0/\nEDMT0iV8RthzeNI2BFPBzOI+kDGbajSqG2eLvH6gTbwxg5Y+uPfgH54K\n")),
    MARKETPLACE_ROOT_V1("atlassian_mpac_intermediate_ca_v1.crt", AtlassianCertificate.format("MIIBiDCCATqgAwIBAgIUYRpJO0DR/qqKlSw6SOAl3C5iPcswBQYDK2VwMDgxEjAQ\nBgNVBAoMCUF0bGFzc2lhbjEiMCAGA1UEAwwZTWFya2V0cGxhY2UgQVMgUm9vdCBD\nQSB2MTAeFw0yNDEyMzEwMDAwMDBaFw0zNDAxMDEwMDAwMDBaMDgxEjAQBgNVBAoM\nCUF0bGFzc2lhbjEiMCAGA1UEAwwZTWFya2V0cGxhY2UgQVMgUm9vdCBDQSB2MTAq\nMAUGAytlcAMhAK3EQa3ZukwKrUcMmp210dN+x6pwF6qzVHiNi/EB1jUTo1YwVDAd\nBgNVHQ4EFgQU7hrebw3cARlhhkaxF8mN03PbMOowHwYDVR0jBBgwFoAU7hrebw3c\nARlhhkaxF8mN03PbMOowEgYDVR0TAQH/BAgwBgEB/wIBATAFBgMrZXADQQAx0Uvv\n0seDT1ncRodzIOFG5n9PdNCc51zGtNkQL4IUidgHRiA7/yAg9hCYkM9AFOUMJHLJ\nMCjxSPSro6vKDtgP\n")),
    MARKETPLACE_INTERMEDIATE_V1("atlassian_mpac_root_ca_v1.crt", AtlassianCertificate.format("MIIBkDCCAUKgAwIBAgIUeN3VUUZtMDpOMj4/53HYAEg7fe8wBQYDK2VwMDgxEjAQ\nBgNVBAoMCUF0bGFzc2lhbjEiMCAGA1UEAwwZTWFya2V0cGxhY2UgQVMgUm9vdCBD\nQSB2MTAeFw0yNDEyMzEwMDAwMDBaFw0yNzAxMTAwMDAwMDBaMEAxEjAQBgNVBAoM\nCUF0bGFzc2lhbjEqMCgGA1UEAwwhTWFya2V0cGxhY2UgQVMgSW50ZXJtZWRpYXRl\nIENBIHYxMCowBQYDK2VwAyEAJMOA3thx/gEukg1W/Mvi0buKyWW9VUZk5CR1n3W9\nhT6jVjBUMB0GA1UdDgQWBBS9amfvKQ0bdj8sD9pzs6+jwTkYfDAfBgNVHSMEGDAW\ngBTuGt5vDdwBGWGGRrEXyY3Tc9sw6jASBgNVHRMBAf8ECDAGAQH/AgEAMAUGAytl\ncANBABqdcd+nGTO+2spHj77Gvn6O5qdDSniwKegNNNsH6HKCNlvZVEomEagf0jmT\n7/D9KijNXJTgdkhDIyQaW2H3eA0=\n"));

    private final String filename;
    private final String certificate;

    private static String format(String certificate) {
        StringBuilder sb = new StringBuilder("-----BEGIN CERTIFICATE-----\n");
        sb.append(certificate).append("-----END CERTIFICATE-----\n");
        return sb.toString();
    }

    private AtlassianCertificate(String filename, String certificate) {
        this.filename = filename;
        this.certificate = certificate;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public static Set<AtlassianCertificate> getCertificates(String selector) {
        if (selector == null) {
            return EnumSet.noneOf(AtlassianCertificate.class);
        }
        switch (selector.toUpperCase()) {
            case "ALL": {
                return Collections.unmodifiableSet(EnumSet.allOf(AtlassianCertificate.class));
            }
            case "PROD": {
                return Collections.unmodifiableSet(EnumSet.of(MARKETPLACE_ROOT_V1, MARKETPLACE_INTERMEDIATE_V1));
            }
            case "STAGING": {
                return Collections.unmodifiableSet(EnumSet.of(MARKETPLACE_STAGING_ROOT, MARKETPLACE_STAGING_INTERMEDIATE));
            }
        }
        return EnumSet.noneOf(AtlassianCertificate.class);
    }
}

