/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import com.atlassian.upm.signing.tool.AtlassianCertificate;
import com.atlassian.upm.signing.tool.FileUtils;
import com.atlassian.upm.signing.tool.PrivateKeyAndCert;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpmConfigWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpmConfigWriter.class);
    public static final String CERT_PEM = "-cert.pem";
    public static final String PK_PEM = "-pk.pem";
    private final Path configFilePath;
    private final Path truststore;
    private final Path privateKeysStore;
    private final List<Path> configPaths;
    private Path rootPath;
    private boolean enabled;
    private final boolean readonly;

    @Deprecated
    public UpmConfigWriter(Path configPath) {
        this(configPath, true, true);
    }

    @Deprecated
    public UpmConfigWriter(Path configPath, boolean enabled, boolean readonly) {
        this(configPath.resolve("upm.properties"), configPath.resolve("truststore"), configPath.resolve("pks"), enabled, readonly);
        this.configPaths.clear();
        this.rootPath = configPath;
        this.configPaths.add(configPath);
        if (Files.exists(this.rootPath, new LinkOption[0]) && !Files.isDirectory(this.rootPath, new LinkOption[0])) {
            throw new IllegalArgumentException("UPM Configuration folder exists and is not a directory : " + this.rootPath);
        }
    }

    public UpmConfigWriter(Path configFilePath, Path truststore, boolean enabled, boolean readonly) {
        this(configFilePath, truststore, truststore.resolveSibling("pks"), enabled, readonly);
    }

    public UpmConfigWriter(Path configFilePath, Path truststore) {
        this(configFilePath, truststore, truststore.resolveSibling("pks"), true, true);
    }

    private UpmConfigWriter(Path configFilePath, Path truststore, Path privateKeysStore, boolean enabled, boolean readonly) {
        this.configFilePath = configFilePath;
        this.truststore = truststore;
        this.privateKeysStore = privateKeysStore;
        this.configPaths = new ArrayList<Path>();
        this.configPaths.add(configFilePath);
        this.configPaths.add(privateKeysStore);
        this.configPaths.add(truststore);
        this.enabled = enabled;
        this.readonly = readonly;
        this.rootPath = null;
        if (Files.exists(truststore, new LinkOption[0]) && !Files.isDirectory(truststore, new LinkOption[0])) {
            throw new IllegalArgumentException("UPM TrustStore folder exists and is not a directory : " + truststore);
        }
        if (Files.exists(privateKeysStore, new LinkOption[0]) && !Files.isDirectory(privateKeysStore, new LinkOption[0])) {
            throw new IllegalArgumentException("UPM Private Keys Store folder exists and is not a directory : " + privateKeysStore);
        }
        if (Files.exists(configFilePath, new LinkOption[0]) && !Files.isRegularFile(configFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException("UPM configuration file exists and is not a regular file : " + configFilePath);
        }
    }

    public Path getConfigFilePath() {
        return this.configFilePath;
    }

    public Path getTrustStorePath() {
        return this.truststore;
    }

    public Path getKeyStorePath() {
        return this.privateKeysStore;
    }

    @Deprecated
    public Path getRootPath() {
        return this.rootPath;
    }

    public Map<String, String> getSystemProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("atlassian.upm.config.loosecheck.allowed", Boolean.TRUE.toString());
        map.put("atlassian.upm.signature.check.disabled", Boolean.toString(!this.enabled));
        if (this.rootPath == null) {
            map.put("atlassian.upm.configuration.file", this.configFilePath.toFile().getAbsolutePath());
            map.put("atlassian.upm.truststore.directory", this.truststore.toFile().getAbsolutePath());
        } else {
            map.put("atlassian.upm.configuration.directory", this.rootPath.toFile().getAbsolutePath());
        }
        return map;
    }

    public void deleteConfiguration() {
        this.makeConfigWritable();
        this.configPaths.stream().filter(Objects::nonNull).forEach(FileUtils::delete);
    }

    public void toggleEnabled() {
        boolean bl = this.enabled = !this.enabled;
        if (Files.exists(this.configFilePath, new LinkOption[0])) {
            this.makeConfigWritable();
            this.writeUpmPropertiesFile(this.configFilePath);
            this.makeConfigReadonly();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean createConfig(boolean deleteIfExists, Set<AtlassianCertificate> marketplaceCertificates) {
        boolean configExists = this.configPaths.stream().anyMatch(x$0 -> Files.exists(x$0, new LinkOption[0]));
        if (configExists && deleteIfExists) {
            this.makeConfigWritable();
            this.deleteConfiguration();
            configExists = false;
        }
        this.makeConfigWritable();
        if (this.rootPath != null && !Files.exists(this.rootPath, new LinkOption[0])) {
            this.rootPath.toFile().mkdirs();
        }
        if (!Files.exists(this.truststore, new LinkOption[0])) {
            this.truststore.toFile().mkdirs();
        }
        if (this.configFilePath != null) {
            this.writeUpmPropertiesFile(this.configFilePath);
        }
        if (marketplaceCertificates != null) {
            marketplaceCertificates.forEach(mc -> this.writeCertificate(mc.getFileName(), mc.getCertificate()));
        }
        this.makeConfigReadonly();
        return !configExists;
    }

    private void writeUpmPropertiesFile(Path configFile) {
        try {
            Properties properties = new Properties();
            StringBuilder sb = new StringBuilder(this.initConfiguration());
            if (Files.exists(configFile, new LinkOption[0])) {
                try (InputStream in = Files.newInputStream(configFile, new OpenOption[0]);){
                    properties.load(in);
                    properties.remove("atlassian.upm.signature.check.disabled");
                    properties.remove("atlassian.upm.signature.check.enabled");
                    if (!properties.isEmpty()) {
                        String additionalProperties = properties.stringPropertyNames().stream().map(k -> k + "=" + properties.getProperty((String)k)).collect(Collectors.joining("\n"));
                        sb.append("\n").append(additionalProperties);
                    }
                }
                catch (IOException ioe) {
                    LOGGER.warn("Fail to read properties from {}", (Object)configFile);
                }
            }
            Files.write(configFile, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot write upm.properties file", ioe);
        }
    }

    private String initConfiguration() {
        return String.join((CharSequence)"\n", Arrays.asList("atlassian.upm.signature.check.disabled=" + !this.enabled, "# Here for UPM < 8.0 compatibility : do not remove", "atlassian.upm.signature.check.enabled=" + this.enabled, "securitycheck.strict=false"));
    }

    public void writeCertificate(String filename, String certificate) {
        Path target = this.truststore.resolve(filename);
        if (!Files.exists(target, new LinkOption[0])) {
            try {
                Files.write(target, certificate.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Failed to write certificate to " + target, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doWithConfigWriteAccess(BooleanSupplier task) {
        try {
            this.makeConfigWritable();
            boolean bl = task.getAsBoolean();
            return bl;
        }
        catch (Exception ioe) {
            LOGGER.warn("Failed to write to truststore", (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            this.makeConfigReadonly();
        }
    }

    public PrivateKeyAndCert getPrivateKeyAndCertificate(String name) {
        return PrivateKeyAndCert.load(this.getCertificatePath(name + CERT_PEM), this.getPrivateKeyPath(name + PK_PEM));
    }

    public boolean writePrivateKeyAndCertificate(String name, PrivateKeyAndCert privateKeyAndCert) {
        if (privateKeyAndCert != null) {
            return this.doWithConfigWriteAccess(() -> this.createPrivateKeyStore() && privateKeyAndCert.write(this.getCertificatePath(name + CERT_PEM), this.getPrivateKeyPath(name + PK_PEM)));
        }
        LOGGER.error("Private Key and certificate are null!");
        return false;
    }

    private Path getCertificatePath(String fileName) {
        return this.truststore.resolve(fileName);
    }

    private Path getPrivateKeyPath(String fileName) {
        return this.privateKeysStore.resolve(fileName);
    }

    private boolean createPrivateKeyStore() {
        if (!Files.exists(this.privateKeysStore, new LinkOption[0])) {
            return this.privateKeysStore.toFile().mkdirs();
        }
        return true;
    }

    private void changeWritePermissions(boolean writable) {
        String type = writable ? "writable" : "readonly";
        this.configPaths.forEach(p -> {
            if (FileUtils.changeWritePermissions(p, writable)) {
                LOGGER.debug("Configuration permissions changed to {} : {}", (Object)type, (Object)this.configFilePath);
            } else {
                LOGGER.warn("Failed ot change configuration permissions to {} : {}", (Object)type, (Object)this.configFilePath);
            }
        });
    }

    public void makeConfigWritable() {
        this.changeWritePermissions(true);
    }

    private void makeConfigReadonly() {
        if (this.readonly) {
            this.changeWritePermissions(false);
        }
    }
}

