/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.osgi.tracker;

import com.atlassian.osgi.tracker.WaitableServiceTracker;
import com.atlassian.osgi.tracker.WaitableServiceTrackerCustomizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public final class WaitableServiceTrackerFactory
implements DisposableBean,
ApplicationListener {
    private final BundleContext bundleContext;
    private final Set<WaitableServiceTracker<?, ?>> serviceTrackers;

    @Autowired
    public WaitableServiceTrackerFactory(BundleContext bundleContext) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.bundleContext.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
            }
        });
        this.serviceTrackers = new CopyOnWriteArraySet();
    }

    public <T> WaitableServiceTracker<T, T> create(Class<T> serviceClass) {
        return this.create(serviceClass, Functions.identity());
    }

    public <K, T> WaitableServiceTracker<K, T> create(Class<T> serviceClass, Function<T, K> keyExtractor) {
        return this.create(serviceClass, keyExtractor, new NoOpWaitableServiceTrackerCustomizer());
    }

    public <T> WaitableServiceTracker<T, T> create(Class<T> serviceClass, WaitableServiceTrackerCustomizer<T> customizer) {
        return this.create(serviceClass, Functions.identity(), customizer);
    }

    public <K, T> WaitableServiceTracker<K, T> create(Class<T> serviceClass, Function<T, K> keyExtractor, WaitableServiceTrackerCustomizer<T> customizer) {
        WaitableServiceTracker<K, T> tracker = new WaitableServiceTracker<K, T>(this.bundleContext, serviceClass, keyExtractor, customizer);
        this.serviceTrackers.add(tracker.open());
        return tracker;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext ctx = ((ContextRefreshedEvent)event).getApplicationContext();
            for (WaitableServiceTracker<?, ?> tracker : this.serviceTrackers) {
                tracker.loadLocalServices(ctx.getBeansOfType(tracker.getServiceClass()).values());
            }
        }
    }

    public void destroy() throws Exception {
        for (WaitableServiceTracker<?, ?> tracker : this.serviceTrackers) {
            tracker.close();
        }
    }

    @VisibleForTesting
    static final class NoOpWaitableServiceTrackerCustomizer<T>
    implements WaitableServiceTrackerCustomizer<T> {
        NoOpWaitableServiceTrackerCustomizer() {
        }

        @Override
        public T adding(T service) {
            return service;
        }

        @Override
        public void removed(T service) {
        }
    }
}

