/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register.listener;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public class WebHookListenerParameters {
    private final String targetUrl;
    private final boolean excludeBody;
    private final String filter;

    public WebHookListenerParameters(String targetUrl, String filter, boolean excludeBody) {
        this.excludeBody = excludeBody;
        this.targetUrl = (String)Preconditions.checkNotNull((Object)targetUrl);
        this.filter = Strings.nullToEmpty((String)filter);
    }

    public String getUrl() {
        return this.targetUrl;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isExcludeBody() {
        return this.excludeBody;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.targetUrl, this.excludeBody, this.filter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WebHookListenerParameters other = (WebHookListenerParameters)obj;
        return Objects.equal((Object)this.targetUrl, (Object)other.targetUrl) && Objects.equal((Object)this.excludeBody, (Object)other.excludeBody) && Objects.equal((Object)this.filter, (Object)other.filter);
    }

    public static final class Names {
        public static final String EXCLUDE_BODY = "excludeBody";
        public static final String FILTER = "filter";
    }
}

