/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.webhooks.spi.EventSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@PublicApi
public class EventSerializers {
    public static final EventSerializer<Object> REFLECTION = new ReflectionEventSerializer<Object>();

    private EventSerializers() {
    }

    public static String objectToJson(Map<String, Object> map) {
        try {
            return new JSONObject(map).toString(2);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    static final class ReflectionEventSerializer<T>
    implements EventSerializer<T> {
        private static final Set<Class<?>> RAW_TYPES = ImmutableSet.builder().add(Boolean.TYPE).add(Boolean.class).add(Byte.TYPE).add(Byte.class).add(Short.TYPE).add(Short.class).add(Integer.TYPE).add(Integer.class).add(Long.TYPE).add(Long.class).add(Float.TYPE).add(Float.class).add(Double.TYPE).add(Double.class).add(Character.TYPE).add(Character.class).add(String.class).build();

        ReflectionEventSerializer() {
        }

        @Override
        public String serialize(T event) {
            return EventSerializers.objectToJson(ReflectionEventSerializer.toMap(event));
        }

        @VisibleForTesting
        static Map<String, Object> toMap(Object object) {
            Field[] fields;
            if (object == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                Object value = ReflectionEventSerializer.getValue(field, object);
                if (value == null) continue;
                builder.put((Object)field.getName(), value);
            }
            return builder.build();
        }

        private static Object getValue(Field field, Object object) {
            return ReflectionEventSerializer.getTransformedValue(ReflectionEventSerializer.getRawValue(field, object));
        }

        private static Object getTransformedValue(Object object) {
            if (object == null) {
                return null;
            }
            if (RAW_TYPES.contains(object.getClass())) {
                return object;
            }
            if (Iterable.class.isAssignableFrom(object.getClass())) {
                return Iterables.transform((Iterable)((Iterable)object), (Function)new Function<Object, Object>(){

                    public Object apply(Object input) {
                        return ReflectionEventSerializer.getTransformedValue(input);
                    }
                });
            }
            return ReflectionEventSerializer.toMap(object);
        }

        private static Object getRawValue(Field field, Object object) {
            boolean isFieldAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object object2 = field.get(object);
                return object2;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Should not happen", e);
            }
            finally {
                field.setAccessible(isFieldAccessible);
            }
        }
    }
}

