/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.api;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.api.util.Channel;
import com.atlassian.webhooks.api.util.Vote;
import com.atlassian.webhooks.spi.WebHookListenerAccessVoter;
import javax.annotation.Nonnull;

public class DefaultWebHookListenerAccessVoter
implements WebHookListenerAccessVoter {
    private final UserManager userManager;

    public DefaultWebHookListenerAccessVoter(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    @Nonnull
    public Vote canCreate(@Nonnull PersistentWebHookListener listener, @Nonnull Channel channel) {
        return this.getDefaultVote(channel);
    }

    @Override
    @Nonnull
    public Vote canRead(@Nonnull PersistentWebHookListener listener, @Nonnull Channel channel) {
        return this.getDefaultVote(channel);
    }

    @Override
    @Nonnull
    public Vote canAdmin(@Nonnull PersistentWebHookListener listener, @Nonnull Channel channel) {
        return this.getDefaultVote(channel);
    }

    @Override
    @Nonnull
    public Vote canPublish(@Nonnull WebHookEvent webHookEvent, @Nonnull WebHookListener listener) {
        return Vote.ALLOW;
    }

    private Vote getDefaultVote(Channel channel) {
        if (channel == Channel.SERVICE) {
            return Vote.ALLOW;
        }
        UserKey key = this.userManager.getRemoteUserKey();
        if (key != null && this.userManager.isAdmin(key)) {
            return Vote.ALLOW;
        }
        return Vote.ABSTAIN;
    }
}

