/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.api;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.RegistrationMethod;
import com.atlassian.webhooks.api.register.listener.WebHookListenerService;
import com.atlassian.webhooks.api.register.listener.WebHookListenerServiceResponse;
import com.atlassian.webhooks.api.util.Channel;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.plugin.api.SecuredWebHookListenerService;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService(value={WebHookListenerService.class})
@Named(value="webHookListenerService")
public class ServiceChannelWebHookListenerService
implements WebHookListenerService {
    private final SecuredWebHookListenerService delegate;

    @Inject
    public ServiceChannelWebHookListenerService(SecuredWebHookListenerService delegate) {
        this.delegate = (SecuredWebHookListenerService)Preconditions.checkNotNull((Object)delegate, (Object)"securedWebHookListenerService");
    }

    @Override
    public Iterable<PersistentWebHookListener> getAllWebHookListeners() {
        return this.delegate.getAllWebHookListeners(Channel.SERVICE);
    }

    @Override
    public Option<PersistentWebHookListener> getWebHookListener(int id) {
        return this.delegate.getWebHookListener(Channel.SERVICE, id);
    }

    @Override
    public WebHookListenerServiceResponse registerWebHookListener(PersistentWebHookListener registrationParameters, RegistrationMethod registrationMethod) {
        return this.delegate.registerWebHookListener(this.toChannel(registrationMethod), registrationParameters);
    }

    @Override
    public WebHookListenerServiceResponse registerWebHookListener(PersistentWebHookListener registrationParameters) {
        return this.delegate.registerWebHookListener(Channel.SERVICE, registrationParameters);
    }

    @Override
    public WebHookListenerServiceResponse updateWebHookListener(int id, WebHookListenerService.WebHookListenerUpdateInput registrationParameters) {
        return this.delegate.updateWebHookListener(Channel.SERVICE, id, registrationParameters);
    }

    @Override
    public MessageCollection deleteWebHookListener(int id) {
        return this.delegate.deleteWebHookListener(Channel.SERVICE, id);
    }

    private Channel toChannel(RegistrationMethod method) {
        switch (method) {
            case SERVICE: {
                return Channel.SERVICE;
            }
            case REST: {
                return Channel.REST;
            }
            case UI: {
                return Channel.UI;
            }
        }
        throw new IllegalArgumentException("Unsupported registration method: " + (Object)((Object)method));
    }
}

