/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.module;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.webhooks.api.register.listener.ModuleDescriptorWebHookListenerRegistry;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class WebHookModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final ModuleDescriptorWebHookListenerRegistry webHookListenerRegistry;
    private String webhookEventId;
    private String url;
    private Boolean excludeBody = null;
    private String filter = null;
    private String webhookPluginKey;

    public WebHookModuleDescriptor(ModuleFactory moduleFactory, ModuleDescriptorWebHookListenerRegistry webHookListenerRegistry) {
        super(moduleFactory);
        this.webHookListenerRegistry = (ModuleDescriptorWebHookListenerRegistry)Preconditions.checkNotNull((Object)webHookListenerRegistry);
    }

    public Void getModule() {
        return null;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.webhookEventId = WebHookModuleDescriptor.getOptionalAttribute(element, "event", this.getKey());
        this.url = WebHookModuleDescriptor.getRequiredUriAttribute(element, "url");
        this.loadParameters(element);
    }

    private void loadParameters(Element element) {
        String excludeBodyStr = WebHookModuleDescriptor.getOptionalAttribute(element, "excludeBody", this.excludeBody);
        this.excludeBody = excludeBodyStr != null ? Boolean.valueOf(excludeBodyStr) : null;
        this.filter = WebHookModuleDescriptor.getOptionalAttribute(element, "filter", this.filter);
        List elements = element.elements("param");
        if (elements != null) {
            for (Element param : elements) {
                String paramKey = WebHookModuleDescriptor.getRequiredAttribute(param, "name");
                if ("excludeBody".equals(paramKey) || "excludeIssueDetails".equals(paramKey)) {
                    this.excludeBody = this.validateUnambiguity(this.excludeBody, Boolean.valueOf(param.getText()), "excludeBody");
                }
                if (!"filter".equals(paramKey) && !"jql".equals("paramKey")) continue;
                this.filter = this.validateUnambiguity(this.filter, param.getText().trim(), "filter");
            }
        }
        this.excludeBody = (Boolean)MoreObjects.firstNonNull((Object)this.excludeBody, (Object)Boolean.FALSE);
        this.filter = Strings.nullToEmpty((String)this.filter);
    }

    private <T> T validateUnambiguity(T paramValue, T newParamValue, String paramName) {
        if (paramValue != null && !newParamValue.equals(paramValue)) {
            throw new IllegalStateException(paramName + " defined twice with different values: " + paramValue + ", " + newParamValue);
        }
        return newParamValue;
    }

    public void enabled() {
        super.enabled();
        this.webHookListenerRegistry.register(this.webhookEventId, this.definedListener());
    }

    private WebHookListener definedListener() {
        return WebHookListener.fromModuleDescriptor(this.getWebhookPluginKey()).to(this.url).excludeBody(this.excludeBody).withFilter(this.filter).build();
    }

    public void disabled() {
        this.webHookListenerRegistry.unregister(this.webhookEventId, this.definedListener());
        super.disabled();
    }

    private static String getOptionalAttribute(Element e, String name, Object defaultValue) {
        String value = e.attributeValue(name);
        return value != null ? value : (defaultValue != null ? defaultValue.toString() : null);
    }

    private static String getRequiredUriAttribute(Element e, String name) {
        return WebHookModuleDescriptor.getRequiredAttribute(e, name);
    }

    private static String getRequiredAttribute(Element e, String name) {
        String value = e.attributeValue(name);
        if (value == null) {
            throw new PluginParseException("Attribute '" + name + "' is required on '" + e.getName() + "'");
        }
        return value;
    }

    public void setWebhookPluginKey(String webhookPluginKey) {
        this.webhookPluginKey = webhookPluginKey;
    }

    public String getWebhookPluginKey() {
        return StringUtils.isNotBlank((String)this.webhookPluginKey) ? this.webhookPluginKey : this.getPluginKey();
    }
}

