/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.rest;

import com.atlassian.sal.api.message.Message;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

public class ErrorCollectionBean {
    private final MessageCollection messageCollection;

    public ErrorCollectionBean(MessageCollection messageCollection) {
        this.messageCollection = messageCollection;
    }

    @JsonProperty
    public List<MessageBean> getMessages() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.messageCollection.getMessages(), (Function)new Function<Message, MessageBean>(){

            public MessageBean apply(Message message) {
                return new MessageBean(message);
            }
        }));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MessageBean {
        private final Message message;

        public MessageBean(Message message) {
            this.message = message;
        }

        @JsonProperty
        public String getKey() {
            return this.message.getKey();
        }

        @JsonProperty
        public Serializable[] getArguments() {
            return this.message.getArguments();
        }
    }
}

