/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.store;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.webhooks.api.events.WebHookClearListenerCacheEvent;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.RegistrationMethod;
import com.atlassian.webhooks.spi.WebHookListenerStore;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService(value={LifecycleAware.class})
@Named(value="webHookListenerCachingStore")
public class WebHookListenerCachingStore
implements LifecycleAware {
    private final WebHookListenerStore webHookListenerStore;
    private final CacheManager cacheManager;
    private volatile CachedReference<Map<Integer, PersistentWebHookListener>> cacheRef;

    @Inject
    public WebHookListenerCachingStore(@Named(value="webHookListenerStore") WebHookListenerStore webHookListenerStore, CacheManager cacheManager) {
        this.webHookListenerStore = (WebHookListenerStore)Preconditions.checkNotNull((Object)webHookListenerStore);
        this.cacheManager = cacheManager;
    }

    public Option<PersistentWebHookListener> getWebHookListener(Integer id) {
        CachedReference<Map<Integer, PersistentWebHookListener>> ref = this.cacheRef;
        if (ref == null) {
            return Option.none();
        }
        return Option.option(((Map)ref.get()).get(id));
    }

    public Iterable<PersistentWebHookListener> getAllWebHookListeners() {
        CachedReference<Map<Integer, PersistentWebHookListener>> ref = this.cacheRef;
        if (ref == null) {
            return Collections.emptyList();
        }
        return ((Map)ref.get()).values();
    }

    public PersistentWebHookListener registerWebHookListener(PersistentWebHookListener listener, RegistrationMethod registrationMethod) {
        PersistentWebHookListener createdListener = this.webHookListenerStore.addWebHook(listener, registrationMethod);
        this.reset();
        return createdListener;
    }

    public PersistentWebHookListener updateWebHookListener(PersistentWebHookListener listener) {
        PersistentWebHookListener listenerParameters = this.webHookListenerStore.updateWebHook(listener);
        this.reset();
        return listenerParameters;
    }

    public void removeWebHookListener(int id) {
        this.webHookListenerStore.removeWebHook(id);
        this.reset();
    }

    public void onStart() {
        this.cacheRef = this.cacheManager.getCachedReference(WebHookListenerCachingStore.class, "listeners", (Supplier)new Supplier<Map<Integer, PersistentWebHookListener>>(){

            public Map<Integer, PersistentWebHookListener> get() {
                Collection<PersistentWebHookListener> allListenerParameters = WebHookListenerCachingStore.this.webHookListenerStore.getAllWebHooks();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PersistentWebHookListener listenerParameters : allListenerParameters) {
                    builder.put(listenerParameters.getId().get(), (Object)listenerParameters);
                }
                return builder.build();
            }
        });
    }

    public void onStop() {
        this.cacheRef = null;
    }

    @EventListener
    public void onClearCacheEvent(WebHookClearListenerCacheEvent clearCacheEvent) {
        this.reset();
    }

    private void reset() {
        CachedReference<Map<Integer, PersistentWebHookListener>> ref = this.cacheRef;
        if (ref != null) {
            ref.reset();
        }
    }
}

