/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class ClassInfo<T> {
    private final Class<T> type;

    private ClassInfo(Class<T> type) {
        this.type = type;
    }

    public static <T> ClassInfo<T> of(Class<T> type) {
        return new ClassInfo<T>(type);
    }

    public List<HierarchyLevel> typeHierarchy() {
        List<HierarchyLevel> hierarchyWithoutObject = ClassInfo.computeHierarchy(this.type);
        hierarchyWithoutObject.add(HierarchyLevel.singleton(Object.class));
        return ImmutableList.copyOf(hierarchyWithoutObject);
    }

    private static List<HierarchyLevel> computeHierarchy(Class type) {
        ArrayList result = Lists.newArrayList();
        if (type != null && !Object.class.equals((Object)type)) {
            result.add(HierarchyLevel.singleton(type));
            LinkedList<Class> superTypes = ClassInfo.superTypes(type);
            List<HierarchyLevel> nextHierarchyLevels = Collections.emptyList();
            while (!superTypes.isEmpty()) {
                nextHierarchyLevels = ClassInfo.zip(nextHierarchyLevels, ClassInfo.computeHierarchy(superTypes.pop()));
            }
            result.addAll(nextHierarchyLevels);
        }
        return result;
    }

    private static LinkedList<Class> superTypes(Class type) {
        LinkedList superTypes = Lists.newLinkedList();
        if (type.getSuperclass() != null) {
            superTypes.add(type.getSuperclass());
        }
        superTypes.addAll(Arrays.asList((Object[])MoreObjects.firstNonNull(type.getInterfaces(), (Object)new Class[0])));
        return superTypes;
    }

    private static List<HierarchyLevel> zip(List<HierarchyLevel> levels1, List<HierarchyLevel> levels2) {
        int maxSize = Math.max(levels1.size(), levels2.size());
        ArrayList zipped = Lists.newArrayListWithCapacity((int)maxSize);
        for (int i = 0; i < maxSize; ++i) {
            zipped.add(HierarchyLevel.combine(ClassInfo.getOrNull(levels1, i), ClassInfo.getOrNull(levels2, i)));
        }
        return zipped;
    }

    private static <T> T getOrNull(List<T> list, int index) {
        return list.size() > index ? (T)list.get(index) : null;
    }

    public static class HierarchyLevel {
        private final Set<Class<?>> types;

        private HierarchyLevel(Iterable<Class<?>> types) {
            this.types = ImmutableSet.copyOf(types);
        }

        static HierarchyLevel singleton(Class<?> type) {
            return new HierarchyLevel(Lists.newArrayList((Object[])new Class[]{type}));
        }

        static HierarchyLevel level(Class<?> ... types) {
            return new HierarchyLevel(Arrays.asList(types));
        }

        public Set<Class<?>> getTypes() {
            return this.types;
        }

        private static HierarchyLevel combine(HierarchyLevel l1, HierarchyLevel l2) {
            LinkedHashSet combined = Sets.newLinkedHashSet();
            if (l1 != null) {
                combined.addAll(l1.types);
            }
            if (l2 != null) {
                combined.addAll(l2.types);
            }
            return new HierarchyLevel(combined);
        }

        public String toString() {
            return this.types.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.types});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HierarchyLevel other = (HierarchyLevel)obj;
            return Objects.equal(this.types, other.types);
        }
    }
}

