/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.datasource;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.audienceproject.shaded.google.common.util.concurrent.RateLimiter;
import com.audienceproject.spark.dynamodb.connector.ColumnSchema;
import com.audienceproject.spark.dynamodb.connector.TableConnector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\b\u0011\u0001mA\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\u0006\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\u0012}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007bB5\u0001\u0005\u0004%\tB\u001b\u0005\u0007s\u0002\u0001\u000b\u0011B6\t\u000b\u001d\u0002A\u0011\t>\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\b\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003#\u0001A\u0011CA\u0007\u0005A!\u0015P\\1n_\u0012\u000bG/Y,sSR,'O\u0003\u0002\u0012%\u0005QA-\u0019;bg>,(oY3\u000b\u0005M!\u0012\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003=\tW\u000fZ5f]\u000e,\u0007O]8kK\u000e$(\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001aB\u0005\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\r=\u0013'.Z2u!\r)\u0013gM\u0007\u0002M)\u0011q\u0005K\u0001\u0006oJLG/\u001a\u0006\u0003S)\n\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005-b\u0013aA:rY*\u0011Q#\f\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023M\tQA)\u0019;b/JLG/\u001a:\u0011\u0005Q:T\"A\u001b\u000b\u0005YR\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005a*$aC%oi\u0016\u0014h.\u00197S_^\f\u0011BY1uG\"\u001c\u0016N_3\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u0007%sG/\u0001\u0007d_2,XN\\*dQ\u0016l\u0017\r\u0005\u0002C\t6\t1I\u0003\u0002*%%\u0011Qi\u0011\u0002\r\u0007>dW/\u001c8TG\",W.\u0019\t\u0003\u0005\u001eK!\u0001S\"\u0003\u001dQ\u000b'\r\\3D_:tWm\u0019;pe\u000611\r\\5f]R\u0004\"a\u0013+\u000e\u00031S!!\u0014(\u0002\u0011\u0011|7-^7f]RT!a\u0014)\u0002\u0015\u0011Lh.Y7pI\n4(G\u0003\u0002R%\u0006A1/\u001a:wS\u000e,7O\u0003\u0002T1\u0005I\u0011-\\1{_:\fwo]\u0005\u0003+2\u0013\u0001\u0002R=oC6|GIQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baS6\fX/\u0011\u0005e\u0003Q\"\u0001\t\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\u0001+\u0001\u0019A!\t\u000b%*\u0001\u0019\u0001$\t\u000b%+\u0001\u0019\u0001&\u0002\r\t,hMZ3s+\u0005\u0001\u0007cA1gg5\t!M\u0003\u0002dI\u00069Q.\u001e;bE2,'BA3=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003O\n\u00141\"\u0011:sCf\u0014UO\u001a4fe\u00069!-\u001e4gKJ\u0004\u0013a\u0003:bi\u0016d\u0015.\\5uKJ,\u0012a\u001b\t\u0003Y^l\u0011!\u001c\u0006\u0003]>\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0001\u0018/\u0001\u0003vi&d'B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011A/^\u0001\u0007O>|w\r\\3\u000b\u0005Y4\u0012AB:iC\u0012,G-\u0003\u0002y[\nY!+\u0019;f\u0019&l\u0017\u000e^3s\u00031\u0011\u0018\r^3MS6LG/\u001a:!)\tYh\u0010\u0005\u0002<y&\u0011Q\u0010\u0010\u0002\u0005+:LG\u000fC\u0003\u0000\u0015\u0001\u00071'\u0001\u0004sK\u000e|'\u000fZ\u0001\u0007G>lW.\u001b;\u0015\u0005\u0005\u0015\u0001cA\u0013\u0002\b%\u0019\u0011\u0011\u0002\u0014\u0003']\u0013\u0018\u000e^3s\u0007>lW.\u001b;NKN\u001c\u0018mZ3\u0002\u000b\u0005\u0014wN\u001d;\u0015\u0003m\fQa\u00197pg\u0016\fQA\u001a7vg\"\u0004")
public class DynamoDataWriter
implements DataWriter<InternalRow> {
    private final int batchSize;
    private final ColumnSchema columnSchema;
    private final TableConnector connector;
    private final DynamoDB client;
    private final ArrayBuffer<InternalRow> buffer;
    private final RateLimiter rateLimiter;

    public ArrayBuffer<InternalRow> buffer() {
        return this.buffer;
    }

    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    public void write(InternalRow record) {
        block0: {
            this.buffer().$plus$eq((Object)record.copy());
            if (this.buffer().size() != this.batchSize) break block0;
            this.flush();
        }
    }

    public WriterCommitMessage commit() {
        this.flush();
        return new WriterCommitMessage(null){};
    }

    public void abort() {
    }

    public void close() {
        this.client.shutdown();
    }

    public void flush() {
        block0: {
            if (!this.buffer().nonEmpty()) break block0;
            this.connector.putItems(this.columnSchema, (Seq<InternalRow>)this.buffer(), this.client, this.rateLimiter());
            this.buffer().clear();
        }
    }

    public DynamoDataWriter(int batchSize, ColumnSchema columnSchema, TableConnector connector, DynamoDB client) {
        this.batchSize = batchSize;
        this.columnSchema = columnSchema;
        this.connector = connector;
        this.client = client;
        this.buffer = new ArrayBuffer(batchSize);
        this.rateLimiter = RateLimiter.create(connector.writeLimit());
    }
}

