/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.NetworkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.Util;
import com.auth0.jwk.VisibleForTesting;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class UrlJwkProvider
implements JwkProvider {
    @VisibleForTesting
    static final String WELL_KNOWN_JWKS_PATH = "/.well-known/jwks.json";
    private final AtomicReference<List<Jwk>> cachedJwks = new AtomicReference();
    final URL url;
    final Proxy proxy;
    final Map<String, String> headers;
    final Integer connectTimeout;
    final Integer readTimeout;
    private final ObjectReader reader;

    public UrlJwkProvider(URL url) {
        this(url, null, null, null, null);
    }

    public UrlJwkProvider(URL url, Integer connectTimeout, Integer readTimeout, Proxy proxy) {
        this(url, connectTimeout, readTimeout, proxy, null);
    }

    public UrlJwkProvider(URL url, Integer connectTimeout, Integer readTimeout, Proxy proxy, Map<String, String> headers) {
        Util.checkArgument(url != null, "A non-null url is required");
        Util.checkArgument(connectTimeout == null || connectTimeout >= 0, "Invalid connect timeout value '" + connectTimeout + "'. Must be a non-negative integer.");
        Util.checkArgument(readTimeout == null || readTimeout >= 0, "Invalid read timeout value '" + readTimeout + "'. Must be a non-negative integer.");
        this.url = url;
        this.proxy = proxy;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.reader = new ObjectMapper().readerFor(Map.class);
        this.headers = headers == null ? Collections.singletonMap("Accept", "application/json") : headers;
    }

    public UrlJwkProvider(URL url, Integer connectTimeout, Integer readTimeout) {
        this(url, connectTimeout, readTimeout, null, null);
    }

    public UrlJwkProvider(String domain) {
        this(UrlJwkProvider.urlForDomain(domain));
    }

    @VisibleForTesting
    void setCachedJwks(List<Jwk> jwks) {
        this.cachedJwks.set(jwks);
    }

    static URL urlForDomain(String domain) {
        Util.checkArgument(!Util.isNullOrEmpty(domain), "A domain is required");
        if (!domain.startsWith("http")) {
            domain = "https://" + domain;
        }
        try {
            URI uri = new URI(domain + WELL_KNOWN_JWKS_PATH).normalize();
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid jwks uri", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getJwks() throws SigningKeyNotFoundException {
        try {
            URLConnection c;
            URLConnection uRLConnection = c = this.proxy == null ? this.url.openConnection() : this.url.openConnection(this.proxy);
            if (this.connectTimeout != null) {
                c.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != null) {
                c.setReadTimeout(this.readTimeout);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                c.setRequestProperty(entry.getKey(), entry.getValue());
            }
            try (InputStream inputStream = c.getInputStream();){
                Map map = (Map)this.reader.readValue(inputStream);
                return map;
            }
        }
        catch (IOException e) {
            throw new NetworkException("Cannot obtain jwks from url " + this.url.toString(), e);
        }
    }

    public List<Jwk> getAll() throws SigningKeyNotFoundException {
        ArrayList<Jwk> jwks = new ArrayList<Jwk>();
        List keys = (List)this.getJwks().get("keys");
        if (keys == null || keys.isEmpty()) {
            throw new SigningKeyNotFoundException("No keys found in " + this.url.toString(), null);
        }
        try {
            for (Map values : keys) {
                jwks.add(Jwk.fromValues(values));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SigningKeyNotFoundException("Failed to parse jwk from json", e);
        }
        return jwks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Jwk> getCachedJwks() throws JwkException {
        List<Jwk> jwks = this.cachedJwks.get();
        if (jwks == null) {
            UrlJwkProvider urlJwkProvider = this;
            synchronized (urlJwkProvider) {
                jwks = this.cachedJwks.get();
                if (jwks == null) {
                    jwks = this.getAll();
                    this.cachedJwks.set(jwks);
                }
            }
        }
        return jwks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Jwk> findKey(String keyId) throws JwkException {
        List<Jwk> jwks = this.getCachedJwks();
        Optional<Jwk> foundKey = this.searchKey(jwks, keyId);
        if (foundKey.isPresent()) {
            return foundKey;
        }
        UrlJwkProvider urlJwkProvider = this;
        synchronized (urlJwkProvider) {
            List<Jwk> freshJwks = this.getAll();
            this.cachedJwks.set(freshJwks);
            return this.searchKey(freshJwks, keyId);
        }
    }

    private Optional<Jwk> searchKey(List<Jwk> jwks, String keyId) {
        if (keyId == null && jwks.size() == 1) {
            return Optional.of(jwks.get(0));
        }
        if (keyId != null) {
            for (Jwk jwk : jwks) {
                if (!keyId.equals(jwk.getId())) continue;
                return Optional.of(jwk);
            }
        }
        return Optional.empty();
    }

    @Override
    public Jwk get(String keyId) throws JwkException {
        return this.findKey(keyId).orElseThrow(() -> new SigningKeyNotFoundException("No key found in " + this.url.toString() + " with kid " + keyId, null));
    }
}

