/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Document;
import com.authlete.common.assurance.Evidence;
import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import com.authlete.common.assurance.Provider;
import com.authlete.common.assurance.Verifier;
import java.util.Map;

public class IDDocument
extends Evidence {
    private static final long serialVersionUID = 1L;
    private static final String ID_DOCUMENT = "id_document";
    private static final String METHOD = "method";
    private static final String VERIFIER = "verifier";
    private static final String TIME = "time";
    private static final String DOCUMENT = "document";

    public IDDocument() {
        super(ID_DOCUMENT);
    }

    public String getMethod() {
        return (String)this.get(METHOD);
    }

    public IDDocument setMethod(String method) {
        this.put(METHOD, method);
        return this;
    }

    public boolean containsMethod() {
        return this.containsKey(METHOD);
    }

    public Provider removeMethod() {
        return (Provider)this.remove(METHOD);
    }

    public Verifier getVerifier() {
        return (Verifier)this.get(VERIFIER);
    }

    public IDDocument setVerifier(Verifier verifier) {
        this.put(VERIFIER, verifier);
        return this;
    }

    public boolean containsVerifier() {
        return this.containsKey(VERIFIER);
    }

    public Verifier removeVerifier() {
        return (Verifier)this.remove(VERIFIER);
    }

    public String getTime() {
        return (String)this.get(TIME);
    }

    public IDDocument setTime(String time) {
        this.put(TIME, time);
        return this;
    }

    public boolean containsTime() {
        return this.containsKey(TIME);
    }

    public String removeTime() {
        return (String)this.remove(TIME);
    }

    public Document getDocument() {
        return (Document)this.get(DOCUMENT);
    }

    public IDDocument setDocument(Document document) {
        this.put(DOCUMENT, document);
        return this;
    }

    public boolean containsDocument() {
        return this.containsKey(DOCUMENT);
    }

    public Document removeDocument() {
        return (Document)this.remove(DOCUMENT);
    }

    public static IDDocument extract(Map<?, ?> map) throws IdentityAssuranceException {
        IDDocument instance = new IDDocument();
        IDDocument.fill(instance, map, ID_DOCUMENT);
        return instance;
    }

    private static void fill(IDDocument instance, Map<?, ?> map, String key) {
        IDDocument.fillMethod(instance, map, key);
        IDDocument.fillVerifier(instance, map, key);
        IDDocument.fillTime(instance, map, key);
        IDDocument.fillDocument(instance, map, key);
    }

    private static void fillMethod(IDDocument instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, METHOD, key, true);
        instance.setMethod(value);
    }

    private static void fillVerifier(IDDocument instance, Map<?, ?> map, String key) {
        Verifier value = Verifier.extract(map, VERIFIER);
        instance.setVerifier(value);
    }

    private static void fillTime(IDDocument instance, Map<?, ?> map, String key) {
        String value = Helper.extractDateTime(map, TIME, key, false);
        instance.setTime(value);
    }

    private static void fillDocument(IDDocument instance, Map<?, ?> map, String key) {
        Helper.ensureKey(map, DOCUMENT, key);
        Document document = Document.extract(map, DOCUMENT);
        Helper.ensureNotNull(document, DOCUMENT);
        instance.setDocument(document);
    }
}

