/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.BaseConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.IssuerConstraint;
import com.authlete.common.assurance.constraint.LeafConstraint;
import java.util.Map;

public class DocumentConstraint
extends BaseConstraint {
    private LeafConstraint type;
    private LeafConstraint number;
    private IssuerConstraint issuer;
    private LeafConstraint dateOfIssuance;
    private LeafConstraint dateOfExpiry;

    public LeafConstraint getType() {
        return this.type;
    }

    public void setType(LeafConstraint constraint) {
        this.type = constraint;
    }

    public LeafConstraint getNumber() {
        return this.number;
    }

    public void setNumber(LeafConstraint constraint) {
        this.number = constraint;
    }

    public IssuerConstraint getIssuer() {
        return this.issuer;
    }

    public void setIssuer(IssuerConstraint constraint) {
        this.issuer = constraint;
    }

    public LeafConstraint getDateOfIssuance() {
        return this.dateOfIssuance;
    }

    public void setDateOfIssuance(LeafConstraint constraint) {
        this.dateOfIssuance = constraint;
    }

    public LeafConstraint getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public void setDateOfExpiry(LeafConstraint constraint) {
        this.dateOfExpiry = constraint;
    }

    public static DocumentConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        DocumentConstraint instance = new DocumentConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            DocumentConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    private static void fill(DocumentConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        instance.type = LeafConstraint.extract(map, "type");
        instance.number = LeafConstraint.extract(map, "number");
        instance.issuer = IssuerConstraint.extract(map, "issuer");
        instance.dateOfIssuance = LeafConstraint.extract(map, "date_of_issuance");
        instance.dateOfExpiry = LeafConstraint.extract(map, "date_of_expiry");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        DocumentConstraint.addIfAvailable(map, "type", this.type);
        DocumentConstraint.addIfAvailable(map, "number", this.number);
        DocumentConstraint.addIfAvailable(map, "issuer", this.issuer);
        DocumentConstraint.addIfAvailable(map, "date_of_issuance", this.dateOfIssuance);
        DocumentConstraint.addIfAvailable(map, "date_of_expiry", this.dateOfExpiry);
        return map;
    }
}

