/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.ConstraintException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;

class Helper {
    Helper() {
    }

    public static ConstraintException exception(String format, Object ... args) {
        return new ConstraintException(String.format(format, args));
    }

    public static void ensureNotNull(Object object, String key) {
        if (object == null) {
            throw Helper.exception("'%s' is null.", key);
        }
    }

    public static Map<?, ?> ensureMap(Object object, String key) {
        if (!(object instanceof Map)) {
            throw Helper.exception("'%s' is not an object.", key);
        }
        return (Map)object;
    }

    public static List<?> ensureList(Object object, String key) {
        if (!(object instanceof List)) {
            throw Helper.exception("'%s' is not an array.", key);
        }
        return (List)object;
    }

    public static boolean ensureBoolean(Object object, String key) {
        if (!(object instanceof Boolean)) {
            throw Helper.exception("'%s' is not a boolean value.", new Object[0]);
        }
        return (Boolean)object;
    }

    public static long ensureLong(Object object, String key) {
        if (!(object instanceof Number)) {
            throw Helper.exception("'%s' is not a number.", new Object[0]);
        }
        return ((Number)object).longValue();
    }

    public static String ensureString(Object object, String key) {
        if (!(object instanceof String)) {
            throw Helper.exception("'%s' is not a string.", new Object[0]);
        }
        return (String)object;
    }

    public static String toJson(Object object) {
        return Helper.toJson(object, false);
    }

    public static String toJson(Object object, boolean pretty) {
        if (object == null) {
            return "null";
        }
        return Helper.createGson(pretty).toJson(object);
    }

    private static Gson createGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder().serializeNulls();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }
}

