/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.BaseConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.EvidenceArrayConstraint;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.LeafConstraint;
import com.authlete.common.assurance.constraint.TimeConstraint;
import java.util.Map;

public class VerificationConstraint
extends BaseConstraint {
    private LeafConstraint trustFramework;
    private TimeConstraint time;
    private LeafConstraint verificationProcess;
    private EvidenceArrayConstraint evidence;

    public LeafConstraint getTrustFramework() {
        return this.trustFramework;
    }

    public void setTrustFramework(LeafConstraint constraint) {
        this.trustFramework = constraint;
    }

    public TimeConstraint getTime() {
        return this.time;
    }

    public void setTime(TimeConstraint constraint) {
        this.time = constraint;
    }

    public LeafConstraint getVerificationProcess() {
        return this.verificationProcess;
    }

    public void setVerificationProcess(LeafConstraint constraint) {
        this.verificationProcess = constraint;
    }

    public EvidenceArrayConstraint getEvidence() {
        return this.evidence;
    }

    public void setEvidence(EvidenceArrayConstraint constraint) {
        this.evidence = constraint;
    }

    public static VerificationConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        VerificationConstraint instance = new VerificationConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            VerificationConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    private static void fill(VerificationConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        instance.trustFramework = LeafConstraint.extract(map, "trust_framework");
        instance.time = TimeConstraint.extract(map, "time");
        instance.verificationProcess = LeafConstraint.extract(map, "verification_process");
        instance.evidence = EvidenceArrayConstraint.extract(map, "evidence");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        VerificationConstraint.addIfAvailable(map, "trust_framework", this.trustFramework);
        VerificationConstraint.addIfAvailable(map, "time", this.time);
        VerificationConstraint.addIfAvailable(map, "verification_process", this.verificationProcess);
        if (this.evidence != null && this.evidence.exists()) {
            map.put("evidence", this.evidence.toList());
        }
        return map;
    }
}

