/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.BaseConstraint;
import com.authlete.common.assurance.constraint.ClaimsConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.VerificationConstraint;
import java.util.Map;

public class VerifiedClaimsConstraint
extends BaseConstraint {
    private VerificationConstraint verification;
    private ClaimsConstraint claims;

    public VerificationConstraint getVerification() {
        return this.verification;
    }

    public void setVerification(VerificationConstraint constraint) {
        this.verification = constraint;
    }

    public ClaimsConstraint getClaims() {
        return this.claims;
    }

    public void setClaims(ClaimsConstraint constraint) {
        this.claims = constraint;
    }

    public boolean isAllClaimsRequested() {
        return this.claims == null || !this.claims.exists() || this.claims.isNull();
    }

    public static VerifiedClaimsConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        VerifiedClaimsConstraint instance = new VerifiedClaimsConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            VerifiedClaimsConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    private static void fill(VerifiedClaimsConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        instance.verification = VerificationConstraint.extract(map, "verification");
        instance.claims = ClaimsConstraint.extract(map, "claims");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        VerifiedClaimsConstraint.addIfAvailable(map, "verification", this.verification);
        if (this.claims != null && this.claims.exists()) {
            map.put("claims", this.claims.toMap());
        }
        return map;
    }
}

