/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ServiceProfile {
    FAPI(1, "fapi"),
    OPEN_BANKING(2, "openbanking");

    private static final ServiceProfile[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private ServiceProfile(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ServiceProfile getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static ServiceProfile parse(String serviceProfile) {
        if (serviceProfile == null) {
            return null;
        }
        for (ServiceProfile entry : sValues) {
            if (!entry.mString.equals(serviceProfile)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ServiceProfile> set) {
        return sHelper.toBits(set);
    }

    public static ServiceProfile[] toArray(int bits) {
        return (ServiceProfile[])sHelper.toArray(bits);
    }

    public static EnumSet<ServiceProfile> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ServiceProfile> toSet(ServiceProfile[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = ServiceProfile.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ServiceProfile> {
        public Helper(ServiceProfile[] values) {
            super(ServiceProfile.class, (Enum[])values);
        }

        @Override
        protected short getValue(ServiceProfile entry) {
            return entry.getValue();
        }

        protected ServiceProfile[] newArray(int size) {
            return new ServiceProfile[size];
        }
    }
}

