/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class StandardClaims {
    public static final String SUB = "sub";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String LOCALE = "locale";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    private static final SortedSet<String> sStandardClaims = StandardClaims.createStandardClaims();
    private static final Map<String, Integer> sClaimToNumberMap = StandardClaims.createClaimToNumberMap();
    private static final String[] sValues = StandardClaims.createValues();

    private static SortedSet<String> createStandardClaims() {
        TreeSet<String> set = new TreeSet<String>();
        set.add(SUB);
        set.add(NAME);
        set.add(GIVEN_NAME);
        set.add(FAMILY_NAME);
        set.add(MIDDLE_NAME);
        set.add(NICKNAME);
        set.add(PREFERRED_USERNAME);
        set.add(PROFILE);
        set.add(PICTURE);
        set.add(WEBSITE);
        set.add(EMAIL);
        set.add(EMAIL_VERIFIED);
        set.add(GENDER);
        set.add(BIRTHDATE);
        set.add(ZONEINFO);
        set.add(LOCALE);
        set.add(PHONE_NUMBER);
        set.add(PHONE_NUMBER_VERIFIED);
        set.add(ADDRESS);
        set.add(UPDATED_AT);
        return Collections.unmodifiableSortedSet(set);
    }

    private static Map<String, Integer> createClaimToNumberMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StandardClaims.put(map, SUB, 1);
        StandardClaims.put(map, NAME, 2);
        StandardClaims.put(map, GIVEN_NAME, 3);
        StandardClaims.put(map, FAMILY_NAME, 4);
        StandardClaims.put(map, MIDDLE_NAME, 5);
        StandardClaims.put(map, NICKNAME, 6);
        StandardClaims.put(map, PREFERRED_USERNAME, 7);
        StandardClaims.put(map, PROFILE, 8);
        StandardClaims.put(map, PICTURE, 9);
        StandardClaims.put(map, WEBSITE, 10);
        StandardClaims.put(map, EMAIL, 11);
        StandardClaims.put(map, EMAIL_VERIFIED, 12);
        StandardClaims.put(map, GENDER, 13);
        StandardClaims.put(map, BIRTHDATE, 14);
        StandardClaims.put(map, ZONEINFO, 15);
        StandardClaims.put(map, LOCALE, 16);
        StandardClaims.put(map, PHONE_NUMBER, 17);
        StandardClaims.put(map, PHONE_NUMBER_VERIFIED, 18);
        StandardClaims.put(map, ADDRESS, 19);
        StandardClaims.put(map, UPDATED_AT, 20);
        return Collections.unmodifiableMap(map);
    }

    private static void put(Map<String, Integer> map, String claim, int number) {
        map.put(claim, number);
    }

    private static String[] createValues() {
        return new String[]{SUB, NAME, GIVEN_NAME, FAMILY_NAME, MIDDLE_NAME, NICKNAME, PREFERRED_USERNAME, PROFILE, PICTURE, WEBSITE, EMAIL, EMAIL_VERIFIED, GENDER, BIRTHDATE, ZONEINFO, LOCALE, PHONE_NUMBER, PHONE_NUMBER_VERIFIED, ADDRESS, UPDATED_AT};
    }

    private StandardClaims() {
    }

    public static boolean isStandardClaim(String claimName) {
        if (claimName == null) {
            return false;
        }
        return sStandardClaims.contains(claimName);
    }

    public static SortedSet<String> getStandardClaims() {
        return sStandardClaims;
    }

    public static int toBits(Set<String> set) {
        if (set == null) {
            return 0;
        }
        int bits = 0;
        for (String claim : set) {
            Integer number = sClaimToNumberMap.get(claim);
            if (number == null) continue;
            bits |= 1 << number;
        }
        return bits;
    }

    public static Set<String> toSet(int bits) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < sValues.length; ++i) {
            if ((bits & 1 << i + 1) == 0) continue;
            set.add(sValues[i]);
        }
        return set;
    }
}

