/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum UserCodeCharset {
    BASE20(1, "BCDFGHJKLMNPQRSTVWXZ"),
    NUMERIC(2, "0123456789");

    private static final UserCodeCharset[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mCharacters;

    private UserCodeCharset(short value, String characters) {
        this.mValue = value;
        this.mCharacters = characters;
    }

    public short getValue() {
        return this.mValue;
    }

    public static UserCodeCharset getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public String getCharacters() {
        return this.mCharacters;
    }

    public static int toBits(EnumSet<UserCodeCharset> set) {
        return sHelper.toBits(set);
    }

    public static UserCodeCharset[] toArray(int bits) {
        return (UserCodeCharset[])sHelper.toArray(bits);
    }

    public static EnumSet<UserCodeCharset> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<UserCodeCharset> toSet(UserCodeCharset[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = UserCodeCharset.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<UserCodeCharset> {
        public Helper(UserCodeCharset[] values) {
            super(UserCodeCharset.class, (Enum[])values);
        }

        @Override
        protected short getValue(UserCodeCharset entry) {
            return entry.getValue();
        }

        protected UserCodeCharset[] newArray(int size) {
            return new UserCodeCharset[size];
        }
    }
}

