/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import com.authlete.common.util.PropertiesWrapper;
import com.authlete.common.util.TypedProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoader {
    public static TypedProperties load(String file) {
        return PropertiesLoader.load(file, FileLocation.values());
    }

    public static TypedProperties load(String file, FileLocation[] locations) {
        if (file == null) {
            throw new IllegalArgumentException("file is null.");
        }
        if (locations == null) {
            throw new IllegalArgumentException("locations is null.");
        }
        TypedProperties properties = null;
        for (FileLocation location : locations) {
            if (location != null && (properties = PropertiesLoader.load(file, location)) != null) break;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypedProperties load(String file, FileLocation location) {
        if (file == null) {
            throw new IllegalArgumentException("file is null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("location is null.");
        }
        InputStream in = null;
        try {
            in = PropertiesLoader.open(file, location);
            if (in == null) {
                TypedProperties typedProperties = null;
                return typedProperties;
            }
            Properties properties = PropertiesLoader.load(in);
            PropertiesWrapper propertiesWrapper = new PropertiesWrapper(properties);
            return propertiesWrapper;
        }
        catch (IOException e) {
            TypedProperties typedProperties = null;
            return typedProperties;
        }
        finally {
            PropertiesLoader.close(in);
        }
    }

    private static InputStream open(String file, FileLocation location) throws IOException {
        switch (location) {
            case FILESYSTEM: {
                return PropertiesLoader.openFileSystem(file);
            }
            case CLASSPATH: {
                return PropertiesLoader.openClasspath(file);
            }
        }
        return null;
    }

    private static InputStream openFileSystem(String file) throws IOException {
        return new FileInputStream(file);
    }

    private static InputStream openClasspath(String file) {
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        return PropertiesLoader.class.getResourceAsStream(file);
    }

    private static void close(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Properties load(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        return properties;
    }

    public static enum FileLocation {
        FILESYSTEM,
        CLASSPATH;

    }
}

