/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.service;

import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TestService {
    public static Boolean testHasAttributes(Test test) {
        if (!(TestService.testHasAuthor(test).booleanValue() || TestService.testHasCategory(test).booleanValue() || TestService.testHasDevice(test).booleanValue())) {
            return false;
        }
        return true;
    }

    public static Boolean testHasAuthor(Test test) {
        return !test.getAuthorContext().isEmpty();
    }

    public static Boolean testHasCategory(Test test) {
        return !test.getCategoryContext().isEmpty();
    }

    public static Boolean testHasDevice(Test test) {
        return !test.getDeviceContext().isEmpty();
    }

    public static Boolean testHasException(Test test) {
        return !test.getExceptionInfoContext().isEmpty();
    }

    public static Boolean testHasChildren(Test test) {
        return !test.getNodeContext().isEmpty();
    }

    public static Boolean testHasLog(Test test) {
        return !test.getLogContext().isEmpty();
    }

    public static Boolean testHasScreenCapture(Test test) {
        return !test.getScreenCaptureContext().isEmpty();
    }

    public static Boolean isTestBehaviorDriven(Test test) {
        if (test.getBddType() != null) {
            return true;
        }
        return false;
    }

    public static String getBehaviorDrivenTypeName(Class<? extends IGherkinFormatterModel> bddType) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = bddType.getMethod("getGherkinName", new Class[0]);
        Object o = method.invoke(null, null);
        return o.toString();
    }

    public static String getBehaviorDrivenTypeName(Test test) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return TestService.getBehaviorDrivenTypeName(test.getBddType());
    }

    public static String getRunDuration(Test test) {
        long diff = test.getEndTime().getTime() - test.getStartTime().getTime();
        long secs = diff / 1000L;
        long millis = diff % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return String.valueOf(hours) + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + millis + "ms";
    }

    public static Long getRunDurationMillis(Test test) {
        return test.getEndTime().getTime() - test.getStartTime().getTime();
    }

    public static String getHierarchicalName(Test test) {
        StringBuilder sb = new StringBuilder(test.getName());
        while (test.getParent() != null) {
            test = test.getParent();
            sb.insert(0, String.valueOf(test.getName()) + ".");
        }
        return sb.toString();
    }
}

