/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.append;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.MediaEntityBuilder;
import com.aventstack.extentreports.append.JsonDeserializer;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class RawEntityConverter {
    private final ExtentReports extent;

    public RawEntityConverter(ExtentReports extent) {
        this.extent = extent;
    }

    public void convertAndApply(File jsonFile) throws IOException {
        if (!jsonFile.exists()) {
            return;
        }
        this.extent.setReportUsesManualConfiguration(true);
        List<Test> tests = new JsonDeserializer(jsonFile).deserialize();
        for (Test test : tests) {
            try {
                if (test.getBddType() == null) {
                    this.createDomain(test, this.extent.createTest(test.getName(), test.getDescription()));
                    continue;
                }
                ExtentTest extentTest = this.extent.createTest(new GherkinKeyword(test.getBddType().getSimpleName()), test.getName(), test.getDescription());
                this.createDomain(test, extentTest);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void createDomain(Test test, ExtentTest extentTest) throws ClassNotFoundException {
        extentTest.getModel().setStartTime(test.getStartTime());
        extentTest.getModel().setEndTime(test.getEndTime());
        this.addMedia(test, extentTest);
        for (Log log : test.getLogs()) {
            if (log.hasException() && log.hasMedia()) {
                this.addMedia(log, extentTest, log.getException().getException());
                continue;
            }
            if (log.hasException()) {
                extentTest.log(log.getStatus(), log.getException().getException());
                continue;
            }
            if (log.hasMedia()) {
                this.addMedia(log, extentTest, null);
                continue;
            }
            extentTest.log(log.getStatus(), log.getDetails());
        }
        test.getAuthorSet().stream().map(x -> x.getName()).forEach(xva$0 -> extentTest.assignAuthor((String)xva$0));
        test.getCategorySet().stream().map(x -> x.getName()).forEach(xva$0 -> extentTest.assignCategory((String)xva$0));
        test.getDeviceSet().stream().map(x -> x.getName()).forEach(xva$0 -> extentTest.assignDevice((String)xva$0));
        for (Test node : test.getChildren()) {
            ExtentTest extentNode = null;
            extentNode = node.getBddType() == null ? extentTest.createNode(node.getName(), node.getDescription()) : extentTest.createNode(new GherkinKeyword(node.getBddType().getSimpleName()), node.getName(), node.getDescription());
            this.addMedia(node, extentNode);
            this.createDomain(node, extentNode);
        }
    }

    private void addMedia(Log log, ExtentTest extentTest, Throwable ex) {
        Media m = log.getMedia();
        if (m.getPath() != null) {
            extentTest.log(log.getStatus(), ex, MediaEntityBuilder.createScreenCaptureFromPath(m.getPath()).build());
        } else if (((ScreenCapture)m).getBase64() != null) {
            extentTest.log(log.getStatus(), ex, MediaEntityBuilder.createScreenCaptureFromBase64String(((ScreenCapture)m).getBase64()).build());
        }
    }

    private void addMedia(Test test, ExtentTest extentTest) {
        if (test.getMedia() != null) {
            for (Media m : test.getMedia()) {
                if (m.getPath() != null) {
                    extentTest.addScreenCaptureFromPath(m.getPath());
                    continue;
                }
                if (!(m instanceof ScreenCapture)) continue;
                extentTest.addScreenCaptureFromBase64String(((ScreenCapture)m).getBase64());
            }
        }
    }
}

